/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils.generics;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

public class OwbTypeVariableImpl {
    private static final Class<?>[] TYPE_VARIABLE_TYPES = new Class[]{TypeVariable.class};

    public static TypeVariable createTypeVariable(TypeVariable typeVariable, Type ... bounds) {
        TypeVariable tv = (TypeVariable)Proxy.newProxyInstance(OwbTypeVariableImpl.class.getClassLoader(), TYPE_VARIABLE_TYPES, (InvocationHandler)new OwbTypeVariableInvocationHandler(typeVariable, bounds));
        return tv;
    }

    public static class OwbTypeVariableInvocationHandler
    implements InvocationHandler {
        private String name;
        private GenericDeclaration genericDeclaration;
        private Type[] bounds;

        public OwbTypeVariableInvocationHandler(TypeVariable typeVariable, Type ... bounds) {
            this.name = typeVariable.getName();
            this.genericDeclaration = typeVariable.getGenericDeclaration();
            this.bounds = bounds == null || bounds.length == 0 ? typeVariable.getBounds() : bounds;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName)) {
                return this.typeVariableEquals(args[0]);
            }
            if ("hashCode".equals(methodName)) {
                return this.typeVariableHashCode();
            }
            if ("toString".equals(methodName)) {
                return this.typeVariableToString();
            }
            if ("getName".equals(methodName)) {
                return this.getName();
            }
            if ("getGenericDeclaration".equals(methodName)) {
                return this.getGenericDeclaration();
            }
            if ("getBounds".equals(methodName)) {
                return this.getBounds();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public GenericDeclaration getGenericDeclaration() {
            return this.genericDeclaration;
        }

        public Type[] getBounds() {
            return (Type[])this.bounds.clone();
        }

        public int typeVariableHashCode() {
            return Arrays.hashCode(this.bounds) ^ this.name.hashCode() ^ this.genericDeclaration.hashCode();
        }

        public boolean typeVariableEquals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TypeVariable) {
                TypeVariable that = (TypeVariable)object;
                return this.name.equals(that.getName()) && this.genericDeclaration.equals(that.getGenericDeclaration()) && Arrays.equals(this.bounds, that.getBounds());
            }
            return false;
        }

        public String typeVariableToString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name);
            if (this.bounds.length > 0) {
                buffer.append(" extends ");
                boolean first = true;
                for (Type bound : this.bounds) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(',');
                    }
                    buffer.append(' ').append(bound);
                }
            }
            return buffer.toString();
        }
    }
}

