/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.differ;

import aQute.bnd.differ.Element;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.FilterParser;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Type;
import aQute.bnd.unmodifiable.Maps;
import aQute.bnd.version.Version;
import aQute.libg.tuple.Pair;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public final class XmlRepoDiffer {
    private static final String KEY_DELIMITER = ":";
    private static final String ATTRIBUTE_DIRECTIVE_DELIMITER = ":";
    private static final Map<String, Object> COMPARATOR_ATTRIBUTES = Maps.ofEntries(new AbstractMap.SimpleEntry<String, String>("osgi.wiring.host", "osgi.wiring.host"), new AbstractMap.SimpleEntry<String, String>("osgi.wiring.bundle", "osgi.wiring.bundle"), new AbstractMap.SimpleEntry<String, String>("osgi.content", "osgi.content"), new AbstractMap.SimpleEntry<String, String>("osgi.wiring.package", "osgi.wiring.package"), new AbstractMap.SimpleEntry<String, String>("osgi.identity", "osgi.identity"), new AbstractMap.SimpleEntry<String, String>("osgi.contract", "osgi.contract"), new AbstractMap.SimpleEntry<String, String>("osgi.extender", "osgi.extender"), new AbstractMap.SimpleEntry<String, String>("osgi.implementation", "osgi.implementation"), new AbstractMap.SimpleEntry<String, String>("osgi.service", "objectClass"), new AbstractMap.SimpleEntry<String, String>("osgi.ee", "osgi.ee"), new AbstractMap.SimpleEntry<String, List<String>>("bnd.maven", Arrays.asList("maven-groupId", "maven-artifactId")));

    private XmlRepoDiffer() {
        throw new IllegalAccessError("Cannot be instantiated");
    }

    public static Element resource(File file) throws Exception {
        return XmlRepoDiffer.resource(file, false);
    }

    public static Element resource(File file, boolean expandFilter) throws Exception {
        ArrayList<Element> resources = new ArrayList<Element>();
        List<Resource> repoResources = XMLResourceParser.getResources(file);
        if (repoResources == null) {
            throw new RuntimeException("Cannot parse the XML - " + file.getName());
        }
        List sortedResources = repoResources.stream().sorted(Comparator.comparing(ResourceUtils::getIdentity)).collect(Collectors.toList());
        for (Resource resource : sortedResources) {
            ArrayList<Element> requirementsElements = new ArrayList<Element>();
            ArrayList<Element> capabilitiesElements = new ArrayList<Element>();
            List capabilities = resource.getCapabilities(null).stream().map(cap -> XmlRepoDiffer.addMissingAttributes(cap, resource)).sorted(Comparator.comparing(Capability::getNamespace)).collect(Collectors.toList());
            for (Capability cap2 : capabilities) {
                Element capabilityElement = XmlRepoDiffer.extractElement(cap2.getAttributes(), cap2.getDirectives(), cap2.getNamespace(), Type.CAPABILITY, expandFilter);
                capabilitiesElements.add(capabilityElement);
            }
            Element capabilitiesElement = new Element(Type.CAPABILITIES, "<capabilities>", capabilitiesElements);
            List requirements = resource.getRequirements(null).stream().map(req -> XmlRepoDiffer.addPlaceholderAttributes(req, resource)).sorted(Comparator.comparing(Requirement::getNamespace)).collect(Collectors.toList());
            for (Requirement req2 : requirements) {
                Element requirementElement = XmlRepoDiffer.extractElement(req2.getAttributes(), req2.getDirectives(), req2.getNamespace(), Type.REQUIREMENT, expandFilter);
                requirementsElements.add(requirementElement);
            }
            Element requirementsElement = new Element(Type.REQUIREMENTS, "<requirements>", requirementsElements);
            String name = ResourceUtils.getIdentity(resource);
            Version version = ResourceUtils.getVersion(resource);
            Element versionElement = new Element(Type.VERSION, String.valueOf(version));
            Element resourceElement = new Element(Type.RESOURCE_ID, name, versionElement, requirementsElement, capabilitiesElement);
            resources.add(resourceElement);
        }
        return new Element(Type.REPOSITORY, "<repository>", resources);
    }

    private static String formatComparatorKey(Map<String, Object> attributes, String namespace) {
        Object value = COMPARATOR_ATTRIBUTES.get(namespace);
        if (value != null) {
            if (value instanceof String) {
                Object v = attributes.get(value);
                if (v instanceof List) {
                    return ((List)v).stream().map(Object::toString).collect(Collectors.joining(":"));
                }
                return v.toString();
            }
            if (value instanceof List) {
                return ((List)value).stream().map(attributes::get).map(Object::toString).collect(Collectors.joining(":"));
            }
        }
        return null;
    }

    private static Requirement addPlaceholderAttributes(Requirement requirement, Resource resource) {
        CapReqBuilder capReqBuilder = CapReqBuilder.clone(requirement);
        capReqBuilder.setResource(resource);
        String namespace = requirement.getNamespace();
        FilterParser filterParser = new FilterParser();
        FilterParser.Expression expression = filterParser.parse(requirement);
        ComparatorKeyAttributeFinder finder = new ComparatorKeyAttributeFinder();
        Pair<String, String> attr = expression.visit(finder);
        String key = attr.getFirst();
        String value = attr.getSecond();
        Object keyNS = COMPARATOR_ATTRIBUTES.get(namespace);
        if (keyNS != null && keyNS.equals(key)) {
            capReqBuilder.addAttribute(key, value);
        }
        return capReqBuilder.buildRequirement();
    }

    private static Capability addMissingAttributes(Capability capability, Resource resource) {
        CapReqBuilder capReqBuilder = CapReqBuilder.clone(capability);
        capReqBuilder.setResource(resource);
        String namespace = capability.getNamespace();
        Map attributes = capability.getAttributes();
        if (namespace.equals("osgi.wiring.package")) {
            String bsn = ResourceUtils.getIdentity(resource);
            Version version = ResourceUtils.getVersion(resource);
            if (attributes.get("bundle-symbolic-name") == null) {
                capReqBuilder.addAttribute("bundle-symbolic-name", bsn);
            }
            if (attributes.get("bundle-version") == null) {
                capReqBuilder.addAttribute("bundle-version", version);
            }
        }
        return capReqBuilder.buildCapability();
    }

    private static Element extractElement(Map<String, Object> attributes, Map<String, ? extends Object> directives, String namespace, Type type, boolean expandFilter) {
        List<Element> attributesElements = XmlRepoDiffer.mapToElements(XmlRepoDiffer.removeKeyAttribute(XmlRepoDiffer.validate(attributes), namespace), Type.ATTRIBUTE, expandFilter);
        List<Element> directivesElements = XmlRepoDiffer.mapToElements(XmlRepoDiffer.removeKeyAttribute(XmlRepoDiffer.validate(directives), namespace), Type.DIRECTIVE, expandFilter);
        String elementName = namespace;
        String comparatorKey = XmlRepoDiffer.formatComparatorKey(attributes, namespace);
        if (comparatorKey != null) {
            elementName = elementName + ":" + comparatorKey;
        }
        List<Element> attributesAndDirectivesElements = Stream.concat(attributesElements.stream(), directivesElements.stream()).collect(Collectors.toList());
        return new Element(type, elementName, attributesAndDirectivesElements);
    }

    public static List<Element> mapToElements(Map<String, ? extends Object> entries, Type type, boolean expandFilter) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Map.Entry<String, ? extends Object> entry : entries.entrySet()) {
            List<Element> children;
            String comparator;
            String name = entry.getKey();
            Object value = entry.getValue();
            if ("filter".equals(name) && expandFilter) {
                type = Type.FILTER;
                comparator = "<filter>";
                children = XmlRepoDiffer.createFilterElement(value.toString());
            } else {
                comparator = name + ":" + value;
                children = null;
            }
            Element element = new Element(type, comparator, children, Delta.ADDED, Delta.REMOVED, null);
            elements.add(element);
        }
        return elements;
    }

    private static Map<String, ? extends Object> validate(Map<String, ? extends Object> entries) {
        HashMap<String, Object> finalEntries = new HashMap<String, Object>();
        for (Map.Entry<String, ? extends Object> entry : entries.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof List) {
                ((List)val).forEach(v -> finalEntries.put(key, v));
                continue;
            }
            finalEntries.put(key, val);
        }
        return finalEntries;
    }

    private static Map<String, ? extends Object> removeKeyAttribute(Map<String, ? extends Object> attributes, String namespace) {
        Object value = COMPARATOR_ATTRIBUTES.get(namespace);
        if (value == null) {
            return attributes;
        }
        if (value instanceof String) {
            attributes.remove(value.toString());
        } else if (value instanceof List) {
            ((List)value).stream().map(Object::toString).forEach(attributes::remove);
        }
        return attributes;
    }

    private static List<Element> createFilterElement(String filter) {
        FilterParser.Expression expression = new FilterParser().parse(filter);
        Map<String, String> attrs = expression.visit(new FilterVisitor());
        return XmlRepoDiffer.mapToElements(attrs, Type.EXPRESSION, false);
    }

    private static class ComparatorKeyAttributeFinder
    extends FilterParser.ExpressionVisitor<Pair<String, String>> {
        public ComparatorKeyAttributeFinder() {
            super(null);
        }

        @Override
        public Pair<String, String> visit(FilterParser.SimpleExpression expr) {
            return Pair.newInstance(expr.getKey(), expr.getValue());
        }

        @Override
        public Pair<String, String> visit(FilterParser.PackageExpression expr) {
            return Pair.newInstance("osgi.wiring.package", expr.getPackageName());
        }

        @Override
        public Pair<String, String> visit(FilterParser.BundleExpression expr) {
            return Pair.newInstance("osgi.wiring.bundle", expr.printExcludingRange());
        }

        @Override
        public Pair<String, String> visit(FilterParser.HostExpression expr) {
            return Pair.newInstance("osgi.wiring.host", expr.getHostName());
        }

        @Override
        public Pair<String, String> visit(FilterParser.IdentityExpression expr) {
            return Pair.newInstance("osgi.identity", expr.getSymbolicName());
        }

        @Override
        public Pair<String, String> visit(FilterParser.PatternExpression expr) {
            return Pair.newInstance(expr.getKey(), expr.getValue());
        }

        @Override
        public Pair<String, String> visit(FilterParser.And expr) {
            return this.visit((FilterParser.SubExpression)expr);
        }

        @Override
        public Pair<String, String> visit(FilterParser.Or expr) {
            return this.visit((FilterParser.SubExpression)expr);
        }

        @Override
        public Pair<String, String> visit(FilterParser.ApproximateExpression expr) {
            return this.visit((FilterParser.SimpleExpression)expr);
        }

        @Override
        public Pair<String, String> visit(FilterParser.RangeExpression expr) {
            return this.visit((FilterParser.SimpleExpression)expr);
        }

        private Pair<String, String> visit(FilterParser.SubExpression expr) {
            for (FilterParser.Expression ex : expr.getExpressions()) {
                if (ex instanceof FilterParser.And || ex instanceof FilterParser.Or) {
                    return this.visit((FilterParser.SubExpression)ex);
                }
                if (!(ex instanceof FilterParser.SimpleExpression)) continue;
                return this.visit((FilterParser.SimpleExpression)ex);
            }
            return Pair.newInstance(null, null);
        }
    }

    private static class FilterVisitor
    extends FilterParser.ExpressionVisitor<Map<String, String>> {
        private final Map<String, String> entries = new HashMap<String, String>();

        public FilterVisitor() {
            super(Collections.emptyMap());
        }

        @Override
        public Map<String, String> visit(FilterParser.SimpleExpression expr) {
            this.entries.computeIfAbsent(expr.getKey(), v -> expr.getValue());
            this.entries.computeIfAbsent("op", v -> Optional.ofNullable(expr.getOp()).map(Object::toString).orElse(null));
            return this.entries;
        }

        @Override
        public Map<String, String> visit(FilterParser.BundleExpression expr) {
            return this.visit(expr, "bsn");
        }

        @Override
        public Map<String, String> visit(FilterParser.HostExpression expr) {
            return this.visit(expr, "host");
        }

        @Override
        public Map<String, String> visit(FilterParser.PackageExpression expr) {
            return this.visit(expr, "package");
        }

        @Override
        public Map<String, String> visit(FilterParser.IdentityExpression expr) {
            return this.visit(expr, "bsn");
        }

        @Override
        public Map<String, String> visit(FilterParser.PatternExpression expr) {
            return this.visit((FilterParser.SimpleExpression)expr);
        }

        @Override
        public Map<String, String> visit(FilterParser.ApproximateExpression expr) {
            return this.visit((FilterParser.SimpleExpression)expr);
        }

        @Override
        public Map<String, String> visit(FilterParser.RangeExpression expr) {
            this.visit((FilterParser.SimpleExpression)expr);
            this.entries.computeIfAbsent("range", v -> expr.getRangeString());
            return this.entries;
        }

        @Override
        public Map<String, String> visit(FilterParser.And expr) {
            return this.visit((FilterParser.SubExpression)expr);
        }

        @Override
        public Map<String, String> visit(FilterParser.Or expr) {
            return this.visit((FilterParser.SubExpression)expr);
        }

        @Override
        public Map<String, String> visit(FilterParser.Not expr) {
            this.entries.computeIfAbsent("query", v -> expr.query());
            return this.entries;
        }

        private Map<String, String> visit(FilterParser.WithRangeExpression expr, String key) {
            this.entries.computeIfAbsent(key, v -> expr.printExcludingRange());
            this.entries.computeIfAbsent("range", v -> Optional.ofNullable(expr.getRangeExpression()).map(Object::toString).orElse(null));
            return this.entries;
        }

        private Map<String, String> visit(FilterParser.SubExpression expr) {
            FilterVisitor visitor = new FilterVisitor();
            for (FilterParser.Expression ex : expr.getExpressions()) {
                this.entries.putAll(ex.visit(visitor));
            }
            return this.entries;
        }
    }
}

