/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class BulkRequestContext {
    private List<String> allPids = new ArrayList<String>();
    private List<Dictionary<String, Object>> whiteListProperties = new ArrayList<Dictionary<String, Object>>();
    private ConfigurationAdmin configAdmin;
    private boolean anonymous = false;
    private Set<Principal> principals = new HashSet<Principal>();
    private Map<String, Dictionary<String, Object>> cachedConfigurations = new HashMap<String, Dictionary<String, Object>>();

    private BulkRequestContext() {
    }

    public static BulkRequestContext newContext(ConfigurationAdmin configAdmin) throws IOException {
        BulkRequestContext context = new BulkRequestContext();
        context.configAdmin = configAdmin;
        try {
            AccessControlContext acc = AccessController.getContext();
            if (acc == null) {
                context.anonymous = true;
            } else {
                Subject subject = Subject.getSubject(acc);
                if (subject == null) {
                    context.anonymous = true;
                } else {
                    context.principals.addAll(subject.getPrincipals());
                }
            }
            for (Configuration config : configAdmin.listConfigurations("(service.pid=jmx.acl*)")) {
                context.allPids.add(config.getPid());
            }
            Configuration[] configs = configAdmin.listConfigurations("(service.pid=jmx.acl.whitelist)");
            if (configs != null) {
                for (Configuration config : configs) {
                    context.whiteListProperties.add(config.getProperties());
                }
            }
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException(ise);
        }
        return context;
    }

    public List<String> getAllPids() {
        return this.allPids;
    }

    public List<Dictionary<String, Object>> getWhitelistProperties() {
        return this.whiteListProperties;
    }

    public Dictionary<String, Object> getConfiguration(String generalPid) throws IOException {
        if (!this.cachedConfigurations.containsKey(generalPid)) {
            this.cachedConfigurations.put(generalPid, this.configAdmin.getConfiguration(generalPid, null).getProperties());
        }
        return this.cachedConfigurations.get(generalPid);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public Set<Principal> getPrincipals() {
        return this.principals;
    }
}

