/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.commands;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableIdRefMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.SubShellAction;
import org.apache.karaf.shell.console.commands.BlueprintCommand;
import org.apache.karaf.shell.console.commands.NumberToStringConverter;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceHandler
implements org.apache.aries.blueprint.NamespaceHandler {
    public static final String ID = "id";
    public static final String ACTION = "action";
    public static final String ACTION_ID = "actionId";
    public static final String COMMAND_BUNDLE = "command-bundle";
    public static final String NAME = "name";
    public static final String COMMAND = "command";
    public static final String COMPLETERS = "completers";
    public static final String OPTIONAL_COMPLETERS = "optional-completers";
    public static final String OPTIONAL_COMPLETERS_PROPERTY = "optionalCompleters";
    public static final String BEAN = "bean";
    public static final String REF = "ref";
    public static final String NULL = "null";
    public static final String MAP = "map";
    public static final String BLUEPRINT_CONTAINER = "blueprintContainer";
    public static final String BLUEPRINT_CONVERTER = "blueprintConverter";
    public static final String SHELL_NAMESPACE_1_0_0 = "http://karaf.apache.org/xmlns/shell/v1.0.0";
    public static final String SHELL_NAMESPACE_1_1_0 = "http://karaf.apache.org/xmlns/shell/v1.1.0";
    private int nameCounter = 0;

    public URL getSchemaLocation(String namespace) {
        if (SHELL_NAMESPACE_1_0_0.equals(namespace)) {
            return this.getClass().getResource("karaf-shell-1.0.0.xsd");
        }
        if (SHELL_NAMESPACE_1_1_0.equals(namespace)) {
            return this.getClass().getResource("karaf-shell-1.1.0.xsd");
        }
        return this.getClass().getResource("karaf-shell-1.1.0.xsd");
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(BlueprintCommand.class));
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        throw new ComponentDefinitionException("Bad xml syntax: node decoration is not supported");
    }

    public Metadata parse(Element element, ParserContext context) {
        if (NamespaceHandler.nodeNameEquals(element, COMMAND_BUNDLE)) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                this.parseChildElement(childElement, context);
            }
            this.registerConverters(context);
            return null;
        }
        throw new IllegalStateException("Unexpected element " + element.getNodeName());
    }

    private void parseChildElement(Element element, ParserContext context) {
        if (NamespaceHandler.nodeNameEquals(element, COMMAND)) {
            this.parseCommand(element, context);
        }
    }

    private void registerConverters(ParserContext context) {
        String converterName = "." + NumberToStringConverter.class.getName();
        if (!context.getComponentDefinitionRegistry().containsComponentDefinition(converterName)) {
            MutablePassThroughMetadata cnv = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
            cnv.setId(converterName);
            cnv.setObject((Object)new NumberToStringConverter());
            context.getComponentDefinitionRegistry().registerTypeConverter((Target)cnv);
        }
    }

    private void parseCommand(Element element, ParserContext context) {
        MutableBeanMetadata command = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        command.setRuntimeClass(BlueprintCommand.class);
        command.addProperty(BLUEPRINT_CONTAINER, (Metadata)this.createRef(context, BLUEPRINT_CONTAINER));
        command.addProperty(BLUEPRINT_CONVERTER, (Metadata)this.createRef(context, BLUEPRINT_CONVERTER));
        NodeList children = element.getChildNodes();
        MutableBeanMetadata action = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (NamespaceHandler.nodeNameEquals(childElement, ACTION)) {
                action = this.parseAction(context, (ComponentMetadata)command, childElement);
                action.setId(this.getName());
                context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)action);
                command.addProperty(ACTION_ID, (Metadata)this.createIdRef(context, action.getId()));
                continue;
            }
            if (NamespaceHandler.nodeNameEquals(childElement, COMPLETERS)) {
                command.addProperty(COMPLETERS, this.parseCompleters(context, (ComponentMetadata)command, childElement));
                continue;
            }
            if (NamespaceHandler.nodeNameEquals(childElement, OPTIONAL_COMPLETERS)) {
                command.addProperty(OPTIONAL_COMPLETERS_PROPERTY, this.parseOptionalCompleters(context, (ComponentMetadata)command, childElement));
                continue;
            }
            throw new ComponentDefinitionException("Bad xml syntax: unknown element '" + childElement.getNodeName() + "'");
        }
        MutableServiceMetadata commandService = (MutableServiceMetadata)context.createMetadata(MutableServiceMetadata.class);
        commandService.setActivation(2);
        commandService.setId(this.getName());
        commandService.setAutoExport(2);
        commandService.setServiceComponent((Target)command);
        String scope = null;
        if (SHELL_NAMESPACE_1_0_0.equals(element.getNamespaceURI())) {
            String function;
            String location = element.getAttribute(NAME);
            if ((location = location.replace('/', ':')).lastIndexOf(58) >= 0) {
                scope = location.substring(0, location.lastIndexOf(58));
                function = location.substring(location.lastIndexOf(58) + 1);
            } else {
                scope = "";
                function = location;
            }
            commandService.addServiceProperty((NonNullMetadata)this.createStringValue(context, "osgi.command.scope"), (Metadata)this.createStringValue(context, scope));
            commandService.addServiceProperty((NonNullMetadata)this.createStringValue(context, "osgi.command.function"), (Metadata)this.createStringValue(context, function));
        } else {
            commandService.addServiceProperty((NonNullMetadata)this.createStringValue(context, "osgi.command.scope"), (Metadata)this.getInvocationValue(context, "getScope", action.getClassName()));
            commandService.addServiceProperty((NonNullMetadata)this.createStringValue(context, "osgi.command.function"), (Metadata)this.getInvocationValue(context, "getName", action.getClassName()));
        }
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)commandService);
        String subShellName = null;
        if (scope != null && !scope.isEmpty()) {
            subShellName = ".subshell." + scope;
        }
        if (subShellName == null || !context.getComponentDefinitionRegistry().containsComponentDefinition(subShellName)) {
            this.setupSubShell(context, action, scope, subShellName);
        }
    }

    private void setupSubShell(ParserContext context, MutableBeanMetadata action, String scope, String subShellName) {
        MutableBeanMetadata subShellAction = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        subShellAction.setRuntimeClass(SubShellAction.class);
        subShellAction.setActivation(2);
        subShellAction.setScope("prototype");
        subShellAction.setId(this.getName());
        if (scope != null && !scope.isEmpty()) {
            subShellAction.addProperty("subShell", (Metadata)this.createStringValue(context, scope));
        } else {
            subShellAction.addProperty("subShell", (Metadata)this.getInvocationValue(context, "getScope", action.getClassName()));
        }
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)subShellAction);
        MutableBeanMetadata subShellCommand = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        subShellCommand.setId(this.getName());
        subShellCommand.setRuntimeClass(BlueprintCommand.class);
        subShellCommand.addProperty(BLUEPRINT_CONTAINER, (Metadata)this.createRef(context, BLUEPRINT_CONTAINER));
        subShellCommand.addProperty(BLUEPRINT_CONVERTER, (Metadata)this.createRef(context, BLUEPRINT_CONVERTER));
        subShellCommand.addProperty(ACTION_ID, (Metadata)this.createIdRef(context, subShellAction.getId()));
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)subShellCommand);
        MutableServiceMetadata subShellCommandService = (MutableServiceMetadata)context.createMetadata(MutableServiceMetadata.class);
        subShellCommandService.setActivation(2);
        subShellCommandService.setId(subShellName == null ? this.getName() : subShellName);
        subShellCommandService.setAutoExport(2);
        subShellCommandService.setServiceComponent((Target)subShellCommand);
        subShellCommandService.addServiceProperty((NonNullMetadata)this.createStringValue(context, "osgi.command.scope"), (Metadata)this.createStringValue(context, "*"));
        if (scope != null && !scope.isEmpty()) {
            subShellCommandService.addServiceProperty((NonNullMetadata)this.createStringValue(context, "osgi.command.function"), (Metadata)this.createStringValue(context, scope));
        } else {
            subShellCommandService.addServiceProperty((NonNullMetadata)this.createStringValue(context, "osgi.command.function"), (Metadata)this.getInvocationValue(context, "getScope", action.getClassName()));
        }
        context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)subShellCommandService);
    }

    private MutableBeanMetadata getInvocationValue(ParserContext context, String method, String className) {
        MutableBeanMetadata scope = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        scope.setRuntimeClass(NamespaceHandler.class);
        scope.setFactoryMethod(method);
        scope.addArgument((Metadata)this.createStringValue(context, className), null, 0);
        return scope;
    }

    private MutableBeanMetadata parseAction(ParserContext context, ComponentMetadata enclosingComponent, Element element) {
        MutableBeanMetadata action = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        action.setActivation(2);
        action.setScope("prototype");
        action.setClassName(element.getAttribute("class"));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (NamespaceHandler.nodeNameEquals(childElement, "argument")) {
                action.addArgument((BeanArgument)context.parseElement(BeanArgument.class, enclosingComponent, childElement));
                continue;
            }
            if (!NamespaceHandler.nodeNameEquals(childElement, "property")) continue;
            action.addProperty((BeanProperty)context.parseElement(BeanProperty.class, enclosingComponent, childElement));
        }
        return action;
    }

    private Metadata parseOptionalCompleters(ParserContext context, ComponentMetadata enclosingComponent, Element element) {
        Metadata metadata = (Metadata)context.parseElement(MapMetadata.class, context.getEnclosingComponent(), element);
        return metadata;
    }

    private Metadata parseCompleters(ParserContext context, ComponentMetadata enclosingComponent, Element element) {
        MutableCollectionMetadata collection = (MutableCollectionMetadata)context.createMetadata(MutableCollectionMetadata.class);
        collection.setCollectionClass(List.class);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Metadata metadata;
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            if (NamespaceHandler.nodeNameEquals(child, REF)) {
                metadata = (Metadata)context.parseElement(RefMetadata.class, context.getEnclosingComponent(), (Element)child);
            } else if (NamespaceHandler.nodeNameEquals(child, NULL)) {
                metadata = (Metadata)context.parseElement(NullMetadata.class, context.getEnclosingComponent(), (Element)child);
            } else if (NamespaceHandler.nodeNameEquals(child, BEAN)) {
                metadata = (Metadata)context.parseElement(BeanMetadata.class, enclosingComponent, (Element)child);
            } else {
                throw new IllegalStateException("Unexpected element " + child.getNodeName());
            }
            collection.addValue(metadata);
        }
        return collection;
    }

    private ValueMetadata createStringValue(ParserContext context, String str) {
        MutableValueMetadata value = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
        value.setStringValue(str);
        return value;
    }

    private RefMetadata createRef(ParserContext context, String id) {
        MutableRefMetadata idref = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
        idref.setComponentId(id);
        return idref;
    }

    private IdRefMetadata createIdRef(ParserContext context, String id) {
        MutableIdRefMetadata idref = (MutableIdRefMetadata)context.createMetadata(MutableIdRefMetadata.class);
        idref.setComponentId(id);
        return idref;
    }

    public synchronized String getName() {
        return "shell-" + ++this.nameCounter;
    }

    private static boolean nodeNameEquals(Node node, String name) {
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }

    public static String getScope(Class<?> action) {
        org.apache.karaf.shell.commands.Command command = action.getAnnotation(org.apache.karaf.shell.commands.Command.class);
        if (command != null) {
            return command.scope();
        }
        Command command2 = action.getAnnotation(Command.class);
        if (command2 != null) {
            return command2.scope();
        }
        return null;
    }

    public static String getName(Class<?> action) {
        org.apache.karaf.shell.commands.Command command = action.getAnnotation(org.apache.karaf.shell.commands.Command.class);
        if (command != null) {
            return command.name();
        }
        Command command2 = action.getAnnotation(Command.class);
        if (command2 != null) {
            return command2.name();
        }
        return null;
    }
}

