/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.juneau.commons.function.OptionalSupplier;
import org.apache.juneau.commons.function.ResettableSupplier;
import org.apache.juneau.commons.function.Snippet;
import org.apache.juneau.commons.function.ThrowingSupplier;
import org.apache.juneau.commons.lang.HashCode;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.settings.Settings;
import org.apache.juneau.commons.settings.StringSetting;
import org.apache.juneau.commons.utils.AnnotationUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

public class Utils {
    public static boolean bool(Object val) {
        return Utils.opt(val).map(Object::toString).map(Boolean::valueOf).orElse(false);
    }

    public static <T> T cast(Class<T> c, Object o) {
        return Utils.nn(o) && c.isInstance(o) ? (T)c.cast(o) : null;
    }

    public static String cn(Object value) {
        return ClassUtils.className(value);
    }

    public static String cns(Object value) {
        return ClassUtils.classNameSimple(value);
    }

    public static String cnsq(Object value) {
        return ClassUtils.classNameSimpleQualified(value);
    }

    public static int cmp(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (Utils.eq(o1.getClass(), o2.getClass()) && o1 instanceof Comparable) {
            Comparable o1a = (Comparable)o1;
            return o1a.compareTo(o2);
        }
        return 0;
    }

    public static <T extends Comparable<T>> boolean lt(T o1, T o2) {
        if (o1 == null) {
            return o2 != null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.compareTo(o2) < 0;
    }

    public static <T extends Comparable<T>> boolean lte(T o1, T o2) {
        if (o1 == null) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        return o1.compareTo(o2) <= 0;
    }

    public static <T extends Comparable<T>> boolean gt(T o1, T o2) {
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return true;
        }
        return o1.compareTo(o2) > 0;
    }

    public static <T extends Comparable<T>> boolean gte(T o1, T o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return true;
        }
        return o1.compareTo(o2) >= 0;
    }

    public static <T> T[] ea(Class<T> type) {
        return (Object[])Array.newInstance(type, 0);
    }

    public static String emptyIfNull(Object value) {
        return value == null ? "" : value.toString();
    }

    public static StringSetting env(String name) {
        return Settings.get().get(name);
    }

    public static <T> T env(String name, T def) {
        return Settings.get().get(name, def);
    }

    public static boolean eq(boolean caseInsensitive, String s1, String s2) {
        return caseInsensitive ? Utils.eqic(s1, s2) : Utils.eq(s1, s2);
    }

    public static <T> boolean eq(T o1, T o2) {
        if (o1 instanceof Annotation) {
            Annotation o1a = (Annotation)o1;
            if (o2 instanceof Annotation) {
                Annotation o2a = (Annotation)o2;
                return AnnotationUtils.equals(o1a, o2a);
            }
        }
        if (Utils.isArray(o1) && Utils.isArray(o2)) {
            int l2;
            int l1 = Array.getLength(o1);
            if (l1 != (l2 = Array.getLength(o2))) {
                return false;
            }
            for (int i = 0; i < l1; ++i) {
                if (!Utils.neq(Array.get(o1, i), Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        return Objects.equals(o1, o2);
    }

    public static <T, U> boolean eq(T o1, U o2, BiPredicate<T, U> test) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        return test.test(o1, o2);
    }

    public static boolean eqic(Object o1, Object o2) {
        return StringUtils.equalsIgnoreCase(o1, o2);
    }

    public static boolean eqic(String s1, String s2) {
        return StringUtils.equalsIgnoreCase(s1, s2);
    }

    public static String f(String pattern, Object ... args) {
        return StringUtils.format(pattern, args);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... t) {
        if (Utils.nn(t)) {
            for (T tt : t) {
                if (!Utils.nn(tt)) continue;
                return tt;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T> T or(T ... t) {
        return Utils.firstNonNull(t);
    }

    public static <T> T def(T value, T defaultValue) {
        return Utils.nn(value) ? value : defaultValue;
    }

    @SafeVarargs
    public static boolean and(boolean ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (boolean v : values) {
            if (v) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static boolean or(boolean ... values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (boolean v : values) {
            if (!v) continue;
            return true;
        }
        return false;
    }

    public static boolean not(boolean value) {
        return !value;
    }

    public static <T extends Comparable<T>> T min(T o1, T o2) {
        if (o1 == null) {
            return o2;
        }
        if (o2 == null) {
            return o1;
        }
        return o1.compareTo(o2) <= 0 ? o1 : o2;
    }

    public static <T extends Comparable<T>> T max(T o1, T o2) {
        if (o1 == null) {
            return o2;
        }
        if (o2 == null) {
            return o1;
        }
        return o1.compareTo(o2) >= 0 ? o1 : o2;
    }

    public static <T extends Number> T abs(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (T)Integer.valueOf(Math.abs(value.intValue()));
        }
        if (value instanceof Long) {
            return (T)Long.valueOf(Math.abs(value.longValue()));
        }
        if (value instanceof Double) {
            return (T)Double.valueOf(Math.abs(value.doubleValue()));
        }
        if (value instanceof Float) {
            return (T)Float.valueOf(Math.abs(value.floatValue()));
        }
        if (value instanceof Short) {
            return (T)Short.valueOf((short)Math.abs(value.shortValue()));
        }
        if (value instanceof Byte) {
            return (T)Byte.valueOf((byte)Math.abs(value.byteValue()));
        }
        return (T)Double.valueOf(Math.abs(value.doubleValue()));
    }

    public static Supplier<String> fs(String pattern, Object ... args) {
        return () -> StringUtils.format(pattern, args);
    }

    public static final int h(Object ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        return HashCode.of(values);
    }

    public static String id(Object o) {
        if (o instanceof Optional) {
            Optional opt = (Optional)o;
            o = opt.orElse(null);
        }
        if (o == null) {
            return null;
        }
        return Utils.cnsq(o) + "@" + System.identityHashCode(o);
    }

    public static boolean isArray(Object o) {
        return Utils.nn(o) && o.getClass().isArray();
    }

    public static boolean isBetween(int n, int lower, int higher) {
        return n >= lower && n <= higher;
    }

    public static boolean e(CharSequence str) {
        return str == null || str.isEmpty();
    }

    public static boolean e(Collection<?> o) {
        if (o == null) {
            return true;
        }
        return o.isEmpty();
    }

    public static boolean e(Map<?, ?> o) {
        if (o == null) {
            return true;
        }
        return o.isEmpty();
    }

    public static boolean e(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Collection) {
            Collection o2 = (Collection)o;
            return o2.isEmpty();
        }
        if (o instanceof Map) {
            Map o2 = (Map)o;
            return o2.isEmpty();
        }
        if (Utils.isArray(o)) {
            return Array.getLength(o) == 0;
        }
        return o.toString().isEmpty();
    }

    public static boolean ne(CharSequence o) {
        return !Utils.e(o);
    }

    public static boolean ne(Collection<?> value) {
        return !Utils.e(value);
    }

    public static boolean ne(Map<?, ?> value) {
        return !Utils.e(value);
    }

    public static boolean ne(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof CharSequence) {
            CharSequence value2 = (CharSequence)value;
            return !value2.isEmpty();
        }
        if (value instanceof Collection) {
            Collection value2 = (Collection)value;
            return !value2.isEmpty();
        }
        if (value instanceof Map) {
            Map value2 = (Map)value;
            return !value2.isEmpty();
        }
        if (Utils.isArray(value)) {
            return Array.getLength(value) > 0;
        }
        return Utils.ne(Utils.s(value));
    }

    public static <T extends Number> boolean nm1(T value) {
        return Utils.nn(value) && value.intValue() != -1;
    }

    public static <T> boolean n(T value) {
        return value == null;
    }

    public static boolean n(Object ... values) {
        if (values == null) {
            return true;
        }
        for (Object v : values) {
            if (v == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isTrue(Boolean value) {
        return Utils.nn(value) && value != false;
    }

    public static String lc(String value) {
        return StringUtils.lowerCase(value);
    }

    public static <T> OptionalSupplier<T> mem(Supplier<T> supplier) {
        AssertionUtils.assertArgNotNull("supplier", supplier);
        AtomicReference cache = new AtomicReference();
        return () -> {
            Optional h = (Optional)cache.get();
            if (h == null && !cache.compareAndSet(null, h = Utils.opt(supplier.get()))) {
                h = (Optional)cache.get();
            }
            return h.orElse(null);
        };
    }

    public static <T> ResettableSupplier<T> memr(Supplier<T> supplier) {
        AssertionUtils.assertArgNotNull("supplier", supplier);
        return new ResettableSupplier<T>(supplier);
    }

    public static <T> T no(Class<T> type) {
        return null;
    }

    public static <T> boolean neq(T s1, T s2) {
        return !Utils.eq(s1, s2);
    }

    public static <T, U> boolean neq(T o1, U o2, BiPredicate<T, U> test) {
        if (o1 == null) {
            return Utils.nn(o2);
        }
        if (o2 == null) {
            return true;
        }
        if (o1 == o2) {
            return false;
        }
        return !test.test(o1, o2);
    }

    public static boolean neqic(String s1, String s2) {
        return !Utils.eqic(s1, s2);
    }

    public static boolean nn(Object o) {
        return o != null;
    }

    public static final <T> Optional<T> opt(T t) {
        return Optional.ofNullable(t);
    }

    public static final <T> Optional<T> opte() {
        return Optional.empty();
    }

    public static final void printLines(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            System.out.println(String.format("%4s:" + lines[i], i + 1));
        }
    }

    public static String r(Object o) {
        return StringUtils.readable(o);
    }

    public static String s(Object val) {
        return val == null ? null : val.toString();
    }

    public static void safe(Snippet snippet) {
        try {
            snippet.run();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw ThrowableUtils.toRex(t);
        }
    }

    public static void quiet(Snippet snippet) {
        try {
            snippet.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void safe(Snippet snippet, Function<Throwable, RuntimeException> exceptionMapper) {
        try {
            snippet.run();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw exceptionMapper.apply(t);
        }
    }

    public static <T> T safe(ThrowingSupplier<T> s) {
        try {
            return s.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ThrowableUtils.rex(e);
        }
    }

    public static <T> T safe(ThrowingSupplier<T> s, Function<Exception, RuntimeException> exceptionMapper) {
        try {
            return s.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw exceptionMapper.apply(e);
        }
    }

    public static <T> T safeCatch(ThrowingSupplier<T> s, Function<Throwable, T> exceptionFunction) {
        try {
            return s.get();
        }
        catch (Throwable e) {
            return exceptionFunction.apply(e);
        }
    }

    public static <T> Optional<T> safeOpt(ThrowingSupplier<T> s) {
        try {
            return Optional.of(s.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T> safeOptCatch(ThrowingSupplier<T> s, Function<Throwable, T> exceptionFunction) {
        try {
            return Utils.opt(s.get());
        }
        catch (Throwable e) {
            return Utils.opt(exceptionFunction.apply(e));
        }
    }

    public static <T> T safeOrNull(ThrowingSupplier<T> s) {
        return Utils.safeOpt(s).orElse(null);
    }

    public static <T> T safeSupplier(ThrowableUtils.SupplierWithThrowable<T> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw ThrowableUtils.toRex(t);
        }
    }

    public static <T> T safeSupplier(ThrowableUtils.SupplierWithThrowable<T> supplier, Function<Throwable, RuntimeException> exceptionMapper) {
        try {
            return supplier.get();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw exceptionMapper.apply(t);
        }
    }

    public static StringBuilder sb(String value) {
        return new StringBuilder(value);
    }

    public static Supplier<String> ss(Supplier<?> s) {
        return StringUtils.stringSupplier(s);
    }

    public static String uc(String value) {
        return StringUtils.upperCase(value);
    }

    public static boolean b(String str) {
        return StringUtils.isBlank(str);
    }

    public static boolean nb(String str) {
        return StringUtils.isNotBlank(str);
    }

    public static String tr(String str) {
        return StringUtils.trim(str);
    }

    public static boolean sw(String str, String prefix) {
        return Utils.and(Utils.nn(str), Utils.nn(prefix)) && str.startsWith(prefix);
    }

    public static boolean ew(String str, String suffix) {
        return Utils.and(Utils.nn(str), Utils.nn(suffix)) && str.endsWith(suffix);
    }

    public static boolean co(String str, String substring) {
        return Utils.and(Utils.nn(str), Utils.nn(substring)) && str.contains(substring);
    }

    public static Object unwrap(Object o) {
        Object o2;
        if (o instanceof Supplier) {
            o2 = (Supplier)o;
            o = Utils.unwrap(o2.get());
        }
        if (o instanceof Value) {
            o2 = (Value)o;
            o = Utils.unwrap(((Value)o2).get());
        }
        if (o instanceof Optional) {
            o2 = (Optional)o;
            o = Utils.unwrap(((Optional)o2).orElse(null));
        }
        return o;
    }

    protected Utils() {
    }

    public static String nullIfEmpty(String value) {
        return StringUtils.isEmpty(value) ? null : value;
    }

    public static <K, V> Map<K, V> nullIfEmpty(Map<K, V> val) {
        return Utils.e(val) ? null : val;
    }

    public static <E> List<E> nullIfEmpty(List<E> val) {
        return Utils.e(val) ? null : val;
    }

    public static <E> Set<E> nullIfEmpty(Set<E> val) {
        return Utils.e(val) ? null : val;
    }
}

