/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.Manifest;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.ThrowableUtils;

public class ManifestFile
extends JsonMap {
    private static final long serialVersionUID = 1L;

    public ManifestFile(File f) throws IOException {
        Manifest mf = new Manifest();
        try (FileInputStream fis = new FileInputStream(f);){
            mf.read(fis);
            this.load(mf);
        }
        catch (IOException e) {
            throw new IOException("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read(f), e);
        }
    }

    public ManifestFile(Path path) throws IOException {
        Manifest mf = new Manifest();
        try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
            mf.read(fis);
            this.load(mf);
        }
        catch (IOException e) {
            throw new IOException("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read(path), e);
        }
    }

    public ManifestFile(Manifest f) {
        this.load(f);
    }

    public ManifestFile(Class<?> c) throws IOException {
        String className = c.getSimpleName() + ".class";
        String classPath = c.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest mf = new Manifest(new URL(manifestPath).openStream());
            this.load(mf);
        }
        catch (MalformedURLException e) {
            throw ThrowableUtils.cast(IOException.class, e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ManifestFile(Reader r) throws IOException {
        this.load(new Manifest(new ByteArrayInputStream(IOUtils.read(r).getBytes(IOUtils.UTF8))));
    }

    public ManifestFile(InputStream is) throws IOException {
        this.load(new Manifest(is));
    }

    private void load(Manifest mf) {
        mf.getMainAttributes().forEach((k, v) -> this.put(k.toString(), (Object)v.toString()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach((k, v) -> sb.append((String)k).append(": ").append(v));
        return sb.toString();
    }
}

