/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.KeywordSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializerWriter;

public final class JsonWriter
extends SerializerWriter {
    private final boolean simpleMode;
    private final boolean escapeSolidus;
    private static final AsciiSet encodedChars = AsciiSet.create("\n\t\b\f\r'\"\\");
    private static final AsciiSet encodedChars2 = AsciiSet.create("\n\t\b\f\r'\"\\/");
    private static final KeywordSet reservedWords = new KeywordSet("arguments", "break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "eval", "export", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "null", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "undefined", "yield");
    private static final AsciiSet validAttrChars = AsciiSet.create().ranges("a-z", "A-Z", "0-9").chars("_").build();
    private static final AsciiSet validFirstAttrChars = AsciiSet.create().ranges("a-z", "A-Z").chars("_").build();
    private final AsciiSet ec;

    protected JsonWriter(Writer out, boolean useWhitespace, int maxIndent, boolean escapeSolidus, char quoteChar, boolean simpleMode, boolean trimStrings, UriResolver uriResolver) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver);
        this.simpleMode = simpleMode;
        this.escapeSolidus = escapeSolidus;
        this.ec = escapeSolidus ? encodedChars2 : encodedChars;
    }

    public JsonWriter stringValue(String s) throws IOException {
        int i;
        char c;
        if (s == null) {
            return this;
        }
        boolean doConvert = false;
        for (i = 0; i < s.length() && !doConvert; doConvert |= this.ec.contains(c), ++i) {
            c = s.charAt(i);
        }
        this.q();
        if (!doConvert) {
            this.out.append(s);
        } else {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                if (this.ec.contains(c)) {
                    if (c == '\n') {
                        this.out.append('\\').append('n');
                        continue;
                    }
                    if (c == '\t') {
                        this.out.append('\\').append('t');
                        continue;
                    }
                    if (c == '\b') {
                        this.out.append('\\').append('b');
                        continue;
                    }
                    if (c == '\f') {
                        this.out.append('\\').append('f');
                        continue;
                    }
                    if (c == this.quoteChar) {
                        this.out.append('\\').append(this.quoteChar);
                        continue;
                    }
                    if (c == '\\') {
                        this.out.append('\\').append('\\');
                        continue;
                    }
                    if (c == '/' && this.escapeSolidus) {
                        this.out.append('\\').append('/');
                        continue;
                    }
                    if (c == '\r') continue;
                    this.out.append(c);
                    continue;
                }
                this.out.append(c);
            }
        }
        this.q();
        return this;
    }

    public JsonWriter attr(String s) throws IOException {
        boolean doConvert;
        if (this.trimStrings) {
            s = StringUtils.trim(s);
        }
        boolean bl = doConvert = !this.simpleMode;
        if (s == null) {
            s = "null";
            doConvert = false;
        } else {
            if (!doConvert) {
                char c;
                for (int i = 0; i < s.length() && !doConvert; doConvert |= !(i != 0 ? validAttrChars.contains(c) : validFirstAttrChars.contains(c)), ++i) {
                    c = s.charAt(i);
                }
            }
            if (!doConvert && (s.isEmpty() || reservedWords.contains(s))) {
                doConvert = true;
            }
        }
        if (doConvert) {
            this.stringValue(s);
        } else {
            this.out.append(s);
        }
        return this;
    }

    public SerializerWriter uriValue(Object uri) throws IOException {
        return this.stringValue(this.uriResolver.resolve(uri));
    }

    @Override
    public JsonWriter cr(int depth) throws IOException {
        super.cr(depth);
        return this;
    }

    @Override
    public JsonWriter cre(int depth) throws IOException {
        super.cre(depth);
        return this;
    }

    public JsonWriter smi(int depth) throws IOException {
        if (depth > this.maxIndent) {
            super.s();
        }
        return this;
    }

    @Override
    public JsonWriter appendln(int indent, String text) throws IOException {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public JsonWriter appendln(String text) throws IOException {
        super.appendln(text);
        return this;
    }

    @Override
    public JsonWriter append(int indent, String text) throws IOException {
        super.append(indent, text);
        return this;
    }

    @Override
    public JsonWriter append(int indent, char c) throws IOException {
        super.append(indent, c);
        return this;
    }

    @Override
    public JsonWriter s() throws IOException {
        super.s();
        return this;
    }

    public JsonWriter s(int indent) throws IOException {
        if (indent <= this.maxIndent) {
            super.s();
        }
        return this;
    }

    @Override
    public JsonWriter q() throws IOException {
        super.q();
        return this;
    }

    @Override
    public JsonWriter i(int indent) throws IOException {
        super.i(indent);
        return this;
    }

    @Override
    public JsonWriter nl(int indent) throws IOException {
        super.nl(indent);
        return this;
    }

    @Override
    public JsonWriter append(Object text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public JsonWriter append(String text) throws IOException {
        super.append(text);
        return this;
    }

    @Override
    public JsonWriter appendIf(boolean b, String text) throws IOException {
        super.appendIf(b, text);
        return this;
    }

    @Override
    public JsonWriter appendIf(boolean b, char c) throws IOException {
        super.appendIf(b, c);
        return this;
    }

    @Override
    public JsonWriter append(char c) throws IOException {
        super.append(c);
        return this;
    }
}

