/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfMetaProvider;
import org.apache.juneau.jena.RdfUtils;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.jena.annotation.RdfSchema;
import org.apache.juneau.xml.Namespace;

public class RdfClassMeta
extends ExtendedClassMeta {
    private final List<Rdf> rdfs;
    private final RdfCollectionFormat collectionFormat;
    private final Namespace namespace;

    public RdfClassMeta(ClassMeta<?> cm, RdfMetaProvider mp) {
        super(cm);
        this.rdfs = cm.getAnnotations(Rdf.class);
        RdfCollectionFormat _collectionFormat = RdfCollectionFormat.DEFAULT;
        for (Rdf a : this.rdfs) {
            if (a.collectionFormat() == RdfCollectionFormat.DEFAULT) continue;
            _collectionFormat = a.collectionFormat();
        }
        this.collectionFormat = _collectionFormat;
        List schemas = cm.getAnnotations(RdfSchema.class);
        this.namespace = RdfUtils.findNamespace(this.rdfs, schemas);
    }

    protected List<Rdf> getAnnotations() {
        return this.rdfs;
    }

    protected RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }
}

