/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.springboot;

import org.apache.juneau.rest.springboot.JuneauRestPostProcessor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class JuneauRestInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Class<?> appClass;

    public JuneauRestInitializer(Class<?> appClass) {
        this.appClass = appClass;
    }

    public JuneauRestInitializer() {
        this.appClass = null;
    }

    public void initialize(ConfigurableApplicationContext ctx) {
        String port = ctx.getEnvironment().getProperty("server.port");
        if (port != null && System.getProperty("juneau.serverPort") == null) {
            System.setProperty("juneau.serverPort", port);
        }
        ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new JuneauRestPostProcessor(ctx, this.appClass));
    }
}

