/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;

public class DefaultingTemporalAccessor
implements TemporalAccessor {
    private final TemporalAccessor inner;
    private final ZoneId zoneId;
    private ZonedDateTime zdt;

    public DefaultingTemporalAccessor(TemporalAccessor inner, ZoneId zoneId) {
        this.inner = inner;
        this.zoneId = zoneId;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return this.inner.isSupported(field);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        R r = this.inner.query(query);
        if (r != null) {
            return r;
        }
        if (query == TemporalQueries.zone() || query == TemporalQueries.zoneId()) {
            return (R)this.zoneId;
        }
        if (query == TemporalQueries.localTime()) {
            if (this.isSupported(ChronoField.INSTANT_SECONDS)) {
                return (R)this.zdt().toLocalTime();
            }
            int hour = 0;
            if (this.isSupported(ChronoField.HOUR_OF_DAY)) {
                hour = this.iget(ChronoField.HOUR_OF_DAY);
            } else if (this.isSupported(ChronoField.HOUR_OF_AMPM)) {
                hour = this.iget(ChronoField.HOUR_OF_AMPM) + 12 * this.iget(ChronoField.AMPM_OF_DAY);
            }
            int minute = this.isSupported(ChronoField.MINUTE_OF_HOUR) ? this.iget(ChronoField.MINUTE_OF_HOUR) : 0;
            int second = this.isSupported(ChronoField.SECOND_OF_MINUTE) ? this.iget(ChronoField.SECOND_OF_MINUTE) : 0;
            int nano = this.isSupported(ChronoField.NANO_OF_SECOND) ? this.iget(ChronoField.NANO_OF_SECOND) : 0;
            return (R)LocalTime.of(hour, minute, second, nano);
        }
        if (query == TemporalQueries.localDate()) {
            if (this.isSupported(ChronoField.INSTANT_SECONDS)) {
                return (R)this.zdt().toLocalDate();
            }
            int year = this.isSupported(ChronoField.YEAR) ? this.iget(ChronoField.YEAR) : 1970;
            int month = this.isSupported(ChronoField.MONTH_OF_YEAR) ? this.iget(ChronoField.MONTH_OF_YEAR) : 1;
            int dayOfMonth = this.isSupported(ChronoField.DAY_OF_MONTH) ? this.iget(ChronoField.DAY_OF_MONTH) : 1;
            return (R)LocalDate.of(year, Month.of(month), dayOfMonth);
        }
        if (query == TemporalQueries.offset()) {
            return (R)this.zoneId.getRules().getOffset(this.zdt().toInstant());
        }
        return null;
    }

    @Override
    public long getLong(TemporalField field) {
        if (this.isSupported(field)) {
            return this.inner.getLong(field);
        }
        if (field == ChronoField.INSTANT_SECONDS) {
            return this.zdt().toEpochSecond();
        }
        if (field == ChronoField.EPOCH_DAY) {
            return this.zdt().toLocalDate().toEpochDay();
        }
        if (field == ChronoField.YEAR) {
            if (this.isSupported(ChronoField.INSTANT_SECONDS)) {
                return this.zdt().toLocalDate().getYear();
            }
            return 1970L;
        }
        if (field == ChronoField.MONTH_OF_YEAR) {
            if (this.isSupported(ChronoField.INSTANT_SECONDS)) {
                return this.zdt().toLocalDate().getMonthValue();
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public int get(TemporalField field) {
        if (this.inner.isSupported(field)) {
            return this.inner.get(field);
        }
        return (int)this.getLong(field);
    }

    private int iget(TemporalField field) {
        return this.inner.get(field);
    }

    private ZonedDateTime zdt() {
        if (this.zdt == null) {
            this.zdt = ZonedDateTime.from(this);
        }
        return this.zdt;
    }
}

