/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ObjectUtils;

public class BasicHtmlDocTemplate
implements HtmlDocTemplate {
    @Override
    public void writeTo(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        w.sTag("html").nl(0);
        w.sTag(1, "head").nl(1);
        this.head(session, w, o);
        w.eTag(1, "head").nl(1);
        w.sTag(1, "body").nl(1);
        this.body(session, w, o);
        w.eTag(1, "body").nl(1);
        w.eTag("html").nl(0);
    }

    protected void head(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] head = session.getHead();
        for (int i = 0; i < head.length; ++i) {
            w.sIf(i > 0).appendln(2, session.resolve(head[i]));
        }
        if (this.hasStyle(session)) {
            w.sTag(2, "style").nl(2);
            this.style(session, w, o);
            w.ie(2).eTag("style").nl(2);
        }
        if (this.hasScript(session)) {
            w.sTag(2, "script").nl(2);
            this.script(session, w, o);
            w.ie(2).eTag("script").nl(2);
        }
    }

    protected void style(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        int i = 0;
        for (String s : session.getStylesheet()) {
            w.sIf(i++ > 0).append(3, "@import ").q().append(session.resolveUri(session.resolve(s))).q().appendln(";");
        }
        if (session.isNowrap()) {
            w.appendln(3, "div.data * {white-space:nowrap;} ");
        }
        for (String s : session.getStyle()) {
            w.sIf(i++ > 0).appendln(3, session.resolve(s));
        }
        for (HtmlWidget hw : session.getWidgets()) {
            w.sIf(i++ > 0).appendln(3, session.resolve(hw.getStyle(session.getVarResolver())));
        }
    }

    protected void script(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        int i = 0;
        for (String s : session.getScript()) {
            w.sIf(i++ > 0).append(3, session.resolve(s)).append('\n');
        }
        for (HtmlWidget hw : session.getWidgets()) {
            w.sIf(i++ > 0).append(3, session.resolve(hw.getScript(session.getVarResolver()))).append('\n');
        }
    }

    protected void body(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        if (this.hasHeader(session)) {
            w.sTag(2, "header").nl(2);
            this.header(session, w, o);
            w.ie(2).eTag("header").nl(2);
        }
        if (this.hasNav(session)) {
            w.sTag(2, "nav").nl(2);
            this.nav(session, w, o);
            w.ie(2).eTag("nav").nl(2);
        }
        w.sTag(2, "section").nl(2);
        w.sTag(3, "article").nl(3);
        this.article(session, w, o);
        w.ie(3).eTag("article").nl(3);
        if (this.hasAside(session)) {
            w.sTag(3, "aside").nl(3);
            this.aside(session, w, o);
            w.ie(3).eTag("aside").nl(3);
        }
        w.ie(2).eTag("section").nl(2);
        if (this.hasFooter(session)) {
            w.sTag(2, "footer").nl(2);
            this.footer(session, w, o);
            w.ie(2).eTag("footer").nl(2);
        }
    }

    protected void header(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] header = session.getHeader();
        for (int i = 0; i < header.length; ++i) {
            w.sIf(i > 0).appendln(3, session.resolve(header[i]));
        }
    }

    protected void nav(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] nav;
        String[] links = session.getNavLinks();
        if (links.length > 0 && !ArrayUtils.contains("NONE", links)) {
            w.sTag(3, "ol").nl(3);
            for (String l : links) {
                w.sTag(4, "li");
                l = session.resolve(l);
                if (l.matches("(?s)\\S+\\:.*")) {
                    int i = l.indexOf(58);
                    String key = l.substring(0, i);
                    String val = l.substring(i + 1).trim();
                    if (val.startsWith("<")) {
                        w.nl(4).appendln(5, val);
                    } else {
                        w.oTag("a").attr("href", (Object)session.resolveUri(val), true).cTag().text(key, true).eTag("a");
                    }
                    w.eTag("li").nl(4);
                    continue;
                }
                w.nl(4).appendln(5, l);
                w.eTag(4, "li").nl(4);
            }
            w.eTag(3, "ol").nl(3);
        }
        if ((nav = session.getNav()).length > 0) {
            for (int i = 0; i < nav.length; ++i) {
                w.sIf(i > 0).appendln(3, session.resolve(nav[i]));
            }
        }
    }

    protected void aside(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] aside = session.getAside();
        for (int i = 0; i < aside.length; ++i) {
            w.sIf(i > 0).appendln(4, session.resolve(aside[i]));
        }
    }

    protected void article(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        w.oTag(4, "div").attr("class", "outerdata").append('>').nl(4);
        w.oTag(5, "div").attr("class", "data").attr("id", "data").append('>').nl(5);
        if (o == null) {
            w.append(6, "<null/>").nl(6);
        } else if (ObjectUtils.isEmpty(o)) {
            String m = session.getNoResultsMessage();
            if (BasicHtmlDocTemplate.exists(m)) {
                w.append(6, session.resolve(m)).nl(6);
            }
        } else {
            session.indent = 6;
            w.flush();
            session.parentSerialize(w, o);
        }
        w.ie(5).eTag("div").nl(5);
        w.ie(4).eTag("div").nl(4);
    }

    protected void footer(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] footer = session.getFooter();
        for (int i = 0; i < footer.length; ++i) {
            w.sIf(i > 0).appendln(3, session.resolve(footer[i]));
        }
    }

    protected boolean hasStyle(HtmlDocSerializerSession session) {
        return true;
    }

    protected boolean hasScript(HtmlDocSerializerSession session) {
        return true;
    }

    protected boolean hasHeader(HtmlDocSerializerSession session) {
        return session.getHeader().length > 0;
    }

    protected boolean hasNav(HtmlDocSerializerSession session) {
        return session.getNav().length > 0 || session.getNavLinks().length > 0;
    }

    protected boolean hasAside(HtmlDocSerializerSession session) {
        return session.getAside().length > 0;
    }

    protected boolean hasFooter(HtmlDocSerializerSession session) {
        return session.getFooter().length > 0;
    }

    private static boolean exists(String s) {
        return s != null && !"NONE".equals(s);
    }
}

