/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gco.InternationalStringAdapter;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;

@TitleProperty(name="sequenceIdentifier")
@XmlType(name="MD_RangeDimension_Type", propOrder={"sequenceIdentifier", "description", "descriptor", "name"})
@XmlRootElement(name="MD_RangeDimension")
@XmlSeeAlso(value={DefaultBand.class})
public class DefaultRangeDimension
extends ISOMetadata
implements RangeDimension {
    private static final long serialVersionUID = 4517148689016920767L;
    private MemberName sequenceIdentifier;
    private InternationalString description;
    private Collection<Identifier> names;

    public DefaultRangeDimension() {
    }

    public DefaultRangeDimension(RangeDimension object) {
        super(object);
        if (object != null) {
            this.sequenceIdentifier = object.getSequenceIdentifier();
            this.description = object.getDescriptor();
            if (object instanceof DefaultRangeDimension) {
                this.names = this.copyCollection(((DefaultRangeDimension)object).getNames(), Identifier.class);
            }
        }
    }

    public static DefaultRangeDimension castOrCopy(RangeDimension object) {
        if (object instanceof Band) {
            return DefaultBand.castOrCopy((Band)object);
        }
        if (object == null || object instanceof DefaultRangeDimension) {
            return (DefaultRangeDimension)object;
        }
        return new DefaultRangeDimension(object);
    }

    @Override
    @XmlElement(name="sequenceIdentifier")
    public MemberName getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    public void setSequenceIdentifier(MemberName newValue) {
        this.checkWritePermission(this.sequenceIdentifier);
        this.sequenceIdentifier = newValue;
    }

    @XmlElement(name="description")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getDescription"})
    @XmlElement(name="descriptor", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getDescriptor() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.getDescription() : null;
    }

    @Deprecated(since="1.0")
    public void setDescriptor(InternationalString newValue) {
        this.setDescription(newValue);
    }

    @UML(identifier="name", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Identifier> getNames() {
        this.names = this.nonNullCollection(this.names, Identifier.class);
        return this.names;
    }

    public void setNames(Collection<? extends Identifier> newValues) {
        this.names = this.writeCollection(newValues, this.names, Identifier.class);
    }

    @XmlElement(name="name")
    private Collection<Identifier> getName() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getNames() : null;
    }
}

