/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.Vector;
import org.apache.sis.util.collection.IntegerList;
import org.apache.sis.util.resources.Errors;

final class PackedVector
extends ArrayVector<Long> {
    private static final long serialVersionUID = 5097586732924434042L;
    static final int MINIMAL_SIZE = 8;
    private final IntegerList data;
    private final long increment;
    private final long offset;

    private PackedVector(Vector source, long increment, long offset, int delta) {
        this.increment = increment;
        this.offset = offset;
        int length = source.size();
        this.data = new IntegerList(length, delta, true);
        for (int i = 0; i < length; ++i) {
            this.data.setInt(i, Math.toIntExact((source.longValue(i) - offset) / increment));
        }
    }

    static PackedVector compress(Vector source, long min2, long max2) {
        long delta = max2 - min2;
        if (delta > 0L) {
            long inc = delta;
            int length = source.size();
            if (length >= 8) {
                for (int i = 0; i < length; ++i) {
                    long r;
                    long t = source.longValue(i) - min2;
                    if (t < 0L) {
                        return null;
                    }
                    if (t % inc == 0L) continue;
                    do {
                        r = inc % t;
                        inc = t;
                    } while ((t = r) != 0L);
                    if (inc != 1L) continue;
                    long high = Long.highestOneBit(delta);
                    if ((high & 0x8000000080008080L) == 0L) break;
                    long limit = high - 1L;
                    if (min2 >= 0L && (limit |= high) < 0L) {
                        return null;
                    }
                    if (max2 > limit || min2 < (limit ^ 0xFFFFFFFFFFFFFFFFL)) break;
                    return null;
                }
                if ((delta /= inc) > Integer.MAX_VALUE) {
                    return null;
                }
                return new PackedVector(source, inc, min2, (int)delta);
            }
        }
        return null;
    }

    @Override
    public Class<Long> getElementType() {
        return Long.class;
    }

    @Override
    public boolean isSinglePrecision() {
        return false;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public double doubleValue(int index) {
        return this.longValue(index);
    }

    @Override
    public float floatValue(int index) {
        return this.longValue(index);
    }

    @Override
    public long longValue(int index) {
        return (long)this.data.getInt(index) * this.increment + this.offset;
    }

    @Override
    public String stringValue(int index) {
        return Long.toString(this.longValue(index));
    }

    @Override
    public Number get(int index) {
        return this.longValue(index);
    }

    @Override
    public Number set(int index, Number value) {
        this.verifyType(value, (byte)6);
        long v = value.longValue();
        if (v >= this.offset && (v -= this.offset) % this.increment == 0L && (v /= this.increment) <= (long)this.data.maximalValue()) {
            Number old = this.get(index);
            this.data.setInt(index, (int)v);
            ++this.modCount;
            return old;
        }
        throw new IllegalArgumentException(Errors.format((short)175, value));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof PackedVector) {
            PackedVector d = (PackedVector)other;
            return d.increment == this.increment && d.offset == this.offset && d.data.equals(this.data);
        }
        return super.equals(other);
    }
}

