/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorerSupplier;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRef;

public abstract class PointRangeQuery
extends Query {
    final String field;
    final int numDims;
    final int bytesPerDim;
    final byte[] lowerPoint;
    final byte[] upperPoint;
    final ArrayUtil.ByteArrayComparator comparator;

    protected PointRangeQuery(String field, byte[] lowerPoint, byte[] upperPoint, int numDims) {
        PointRangeQuery.checkArgs(field, lowerPoint, upperPoint);
        this.field = field;
        if (numDims <= 0) {
            throw new IllegalArgumentException("numDims must be positive, got " + numDims);
        }
        if (lowerPoint.length == 0) {
            throw new IllegalArgumentException("lowerPoint has length of zero");
        }
        if (lowerPoint.length % numDims != 0) {
            throw new IllegalArgumentException("lowerPoint is not a fixed multiple of numDims");
        }
        if (lowerPoint.length != upperPoint.length) {
            throw new IllegalArgumentException("lowerPoint has length=" + lowerPoint.length + " but upperPoint has different length=" + upperPoint.length);
        }
        this.numDims = numDims;
        this.bytesPerDim = lowerPoint.length / numDims;
        this.lowerPoint = lowerPoint;
        this.upperPoint = upperPoint;
        this.comparator = ArrayUtil.getUnsignedComparator(this.bytesPerDim);
    }

    public static void checkArgs(String field, Object lowerPoint, Object upperPoint) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (lowerPoint == null) {
            throw new IllegalArgumentException("lowerPoint must not be null");
        }
        if (upperPoint == null) {
            throw new IllegalArgumentException("upperPoint must not be null");
        }
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            private boolean matches(byte[] packedValue) {
                int offset = 0;
                int dim = 0;
                while (dim < PointRangeQuery.this.numDims) {
                    if (PointRangeQuery.this.comparator.compare(packedValue, offset, PointRangeQuery.this.lowerPoint, offset) < 0) {
                        return false;
                    }
                    if (PointRangeQuery.this.comparator.compare(packedValue, offset, PointRangeQuery.this.upperPoint, offset) > 0) {
                        return false;
                    }
                    ++dim;
                    offset += PointRangeQuery.this.bytesPerDim;
                }
                return true;
            }

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator) throws IOException {
                        this.adder.add(iterator);
                    }

                    @Override
                    public void visit(IntsRef ref) {
                        this.adder.add(ref);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (this.matches(packedValue)) {
                            this.adder.add(iterator);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return PointRangeQuery.this.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            private PointValues.IntersectVisitor getInverseIntersectVisitor(final FixedBitSet result, final long[] cost) {
                return new PointValues.IntersectVisitor(){

                    @Override
                    public void visit(int docID) {
                        result.set(docID);
                        cost[0] = cost[0] + 1L;
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator) throws IOException {
                        result.or(iterator);
                        cost[0] = cost[0] + iterator.cost();
                    }

                    @Override
                    public void visit(IntsRef ref) {
                        int to = ref.offset + ref.length;
                        for (int i = ref.offset; i < to; ++i) {
                            result.set(ref.ints[i]);
                        }
                        cost[0] = cost[0] + (long)ref.length;
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (!this.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                        if (!this.matches(packedValue)) {
                            this.visit(iterator);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        PointValues.Relation relation = PointRangeQuery.this.relate(minPackedValue, maxPackedValue);
                        switch (relation) {
                            case CELL_INSIDE_QUERY: {
                                return PointValues.Relation.CELL_OUTSIDE_QUERY;
                            }
                            case CELL_OUTSIDE_QUERY: {
                                return PointValues.Relation.CELL_INSIDE_QUERY;
                            }
                        }
                        return relation;
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                boolean allDocsMatch;
                final LeafReader reader = context2.reader();
                final PointValues values = reader.getPointValues(PointRangeQuery.this.field);
                if (!PointRangeQuery.this.checkValidPointValues(values)) {
                    return null;
                }
                if (values.getDocCount() == 0) {
                    return null;
                }
                byte[] fieldPackedLower = values.getMinPackedValue();
                byte[] fieldPackedUpper = values.getMaxPackedValue();
                for (int i = 0; i < PointRangeQuery.this.numDims; ++i) {
                    int offset = i * PointRangeQuery.this.bytesPerDim;
                    if (PointRangeQuery.this.comparator.compare(PointRangeQuery.this.lowerPoint, offset, fieldPackedUpper, offset) <= 0 && PointRangeQuery.this.comparator.compare(PointRangeQuery.this.upperPoint, offset, fieldPackedLower, offset) >= 0) continue;
                    return null;
                }
                if (values.getDocCount() == reader.maxDoc()) {
                    byte[] fieldPackedLower2 = values.getMinPackedValue();
                    byte[] fieldPackedUpper2 = values.getMaxPackedValue();
                    allDocsMatch = true;
                    for (int i = 0; i < PointRangeQuery.this.numDims; ++i) {
                        int offset = i * PointRangeQuery.this.bytesPerDim;
                        if (PointRangeQuery.this.comparator.compare(PointRangeQuery.this.lowerPoint, offset, fieldPackedLower2, offset) <= 0 && PointRangeQuery.this.comparator.compare(PointRangeQuery.this.upperPoint, offset, fieldPackedUpper2, offset) >= 0) continue;
                        allDocsMatch = false;
                        break;
                    }
                } else {
                    allDocsMatch = false;
                }
                if (allDocsMatch) {
                    return ConstantScoreScorerSupplier.matchAll(this.score(), scoreMode, reader.maxDoc());
                }
                return new ConstantScoreScorerSupplier(this.score(), scoreMode, reader.maxDoc()){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    {
                        super(score, scoreMode, maxDoc);
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values);
                        this.visitor = this.getIntersectVisitor(this.result);
                        this.cost = -1L;
                    }

                    @Override
                    public DocIdSetIterator iterator(long leadCost) throws IOException {
                        if (values.getDocCount() == reader.maxDoc() && (long)values.getDocCount() == values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                            FixedBitSet result = new FixedBitSet(reader.maxDoc());
                            long[] cost = new long[1];
                            values.intersect(this.getInverseIntersectVisitor(result, cost));
                            result.flip(0, reader.maxDoc());
                            cost[0] = Math.max(0L, (long)reader.maxDoc() - cost[0]);
                            return new BitSetIterator(result, cost[0]);
                        }
                        values.intersect(this.visitor);
                        return this.result.build().iterator();
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public int count(LeafReaderContext context2) throws IOException {
                LeafReader reader = context2.reader();
                PointValues values = reader.getPointValues(PointRangeQuery.this.field);
                if (!PointRangeQuery.this.checkValidPointValues(values)) {
                    return 0;
                }
                if (!reader.hasDeletions()) {
                    if (PointRangeQuery.this.relate(values.getMinPackedValue(), values.getMaxPackedValue()) == PointValues.Relation.CELL_INSIDE_QUERY) {
                        return values.getDocCount();
                    }
                    if (PointRangeQuery.this.numDims == 1 && (long)values.getDocCount() == values.size()) {
                        return (int)this.pointCount(values.getPointTree(), PointRangeQuery.this::relate, this::matches);
                    }
                }
                return super.count(context2);
            }

            private long pointCount(PointValues.PointTree pointTree, final BiFunction<byte[], byte[], PointValues.Relation> nodeComparator, final Predicate<byte[]> leafComparator) throws IOException {
                final long[] matchingNodeCount = new long[]{0L};
                PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){

                    @Override
                    public void visit(int docID) {
                        throw new UnsupportedOperationException("This IntersectVisitor does not perform any actions on a docID=" + docID + " node being visited");
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (leafComparator.test(packedValue)) {
                            matchingNodeCount[0] = matchingNodeCount[0] + 1L;
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return (PointValues.Relation)((Object)nodeComparator.apply(minPackedValue, maxPackedValue));
                    }
                };
                this.pointCount(visitor, pointTree, matchingNodeCount);
                return matchingNodeCount[0];
            }

            private void pointCount(PointValues.IntersectVisitor visitor, PointValues.PointTree pointTree, long[] matchingNodeCount) throws IOException {
                PointValues.Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
                switch (r) {
                    case CELL_OUTSIDE_QUERY: {
                        return;
                    }
                    case CELL_INSIDE_QUERY: {
                        matchingNodeCount[0] = matchingNodeCount[0] + pointTree.size();
                        return;
                    }
                    case CELL_CROSSES_QUERY: {
                        if (pointTree.moveToChild()) {
                            do {
                                this.pointCount(visitor, pointTree, matchingNodeCount);
                            } while (pointTree.moveToSibling());
                            pointTree.moveToParent();
                        } else {
                            pointTree.visitDocValues(visitor);
                        }
                        return;
                    }
                }
                throw new IllegalArgumentException("Unreachable code");
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int getBytesPerDim() {
        return this.bytesPerDim;
    }

    public byte[] getLowerPoint() {
        return (byte[])this.lowerPoint.clone();
    }

    public byte[] getUpperPoint() {
        return (byte[])this.upperPoint.clone();
    }

    @Override
    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.lowerPoint);
        hash = 31 * hash + Arrays.hashCode(this.upperPoint);
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + Objects.hashCode(this.bytesPerDim);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((PointRangeQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(PointRangeQuery other) {
        return Objects.equals(this.field, other.field) && this.numDims == other.numDims && this.bytesPerDim == other.bytesPerDim && Arrays.equals(this.lowerPoint, other.lowerPoint) && Arrays.equals(this.upperPoint, other.upperPoint);
    }

    @Override
    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        for (int i = 0; i < this.numDims; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            int startOffset = this.bytesPerDim * i;
            sb.append('[');
            sb.append(this.toString(i, ArrayUtil.copyOfSubArray(this.lowerPoint, startOffset, startOffset + this.bytesPerDim)));
            sb.append(" TO ");
            sb.append(this.toString(i, ArrayUtil.copyOfSubArray(this.upperPoint, startOffset, startOffset + this.bytesPerDim)));
            sb.append(']');
        }
        return sb.toString();
    }

    protected abstract String toString(int var1, byte[] var2);

    @Override
    public Query rewrite(IndexSearcher searcher) throws IOException {
        IndexReader reader = searcher.getIndexReader();
        for (LeafReaderContext leaf : reader.leaves()) {
            this.checkValidPointValues(leaf.reader().getPointValues(this.field));
        }
        byte[] globalMinPacked = PointValues.getMinPackedValue(reader, this.getField());
        byte[] globalMaxPacked = PointValues.getMaxPackedValue(reader, this.getField());
        if (globalMinPacked == null || globalMaxPacked == null) {
            return new MatchNoDocsQuery();
        }
        return switch (this.relate(globalMinPacked, globalMaxPacked)) {
            default -> throw new MatchException(null, null);
            case PointValues.Relation.CELL_INSIDE_QUERY -> {
                if (this.canRewriteToMatchAllQuery(reader)) {
                    yield new MatchAllDocsQuery();
                }
                if (this.canRewriteToFieldExistsQuery(reader)) {
                    yield new FieldExistsQuery(this.field);
                }
                yield super.rewrite(searcher);
            }
            case PointValues.Relation.CELL_OUTSIDE_QUERY -> new MatchNoDocsQuery();
            case PointValues.Relation.CELL_CROSSES_QUERY -> super.rewrite(searcher);
        };
    }

    private boolean canRewriteToMatchAllQuery(IndexReader reader) throws IOException {
        for (LeafReaderContext context2 : reader.leaves()) {
            LeafReader leaf = context2.reader();
            PointValues values = leaf.getPointValues(this.field);
            if (values != null && values.getDocCount() == leaf.maxDoc()) continue;
            return false;
        }
        return true;
    }

    private boolean canRewriteToFieldExistsQuery(IndexReader reader) {
        for (LeafReaderContext leaf : reader.leaves()) {
            FieldInfo info = leaf.reader().getFieldInfos().fieldInfo(this.field);
            if (info == null || info.getDocValuesType() != DocValuesType.NONE || info.hasNorms() || info.getVectorDimension() != 0) continue;
            return false;
        }
        return true;
    }

    private PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
        boolean crosses = false;
        int offset = 0;
        int dim = 0;
        while (dim < this.numDims) {
            if (this.comparator.compare(minPackedValue, offset, this.upperPoint, offset) > 0 || this.comparator.compare(maxPackedValue, offset, this.lowerPoint, offset) < 0) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (!crosses) {
                crosses = this.comparator.compare(minPackedValue, offset, this.lowerPoint, offset) < 0 || this.comparator.compare(maxPackedValue, offset, this.upperPoint, offset) > 0;
            }
            ++dim;
            offset += this.bytesPerDim;
        }
        if (crosses) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_INSIDE_QUERY;
    }

    private boolean checkValidPointValues(PointValues values) throws IOException {
        if (values == null) {
            return false;
        }
        if (values.getNumIndexDimensions() != this.numDims) {
            throw new IllegalArgumentException("field=\"" + this.field + "\" was indexed with numIndexDimensions=" + values.getNumIndexDimensions() + " but this query has numDims=" + this.numDims);
        }
        if (this.bytesPerDim != values.getBytesPerDimension()) {
            throw new IllegalArgumentException("field=\"" + this.field + "\" was indexed with bytesPerDim=" + values.getBytesPerDimension() + " but this query has bytesPerDim=" + this.bytesPerDim);
        }
        return true;
    }
}

