/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdflink.LinkDatasetGraph;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.LinkSparqlUpdate;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.update.UpdateRequest;

public class RDFLinkModular
implements RDFLink {
    private final LinkSparqlQuery queryConnection;
    private final LinkSparqlUpdate updateConnection;
    private final LinkDatasetGraph datasetConnection;
    private final Transactional transactional;

    @Override
    public void begin() {
        this.transactional.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.transactional.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.transactional.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote promote) {
        return this.transactional.promote(promote);
    }

    @Override
    public void commit() {
        this.transactional.commit();
    }

    @Override
    public void abort() {
        this.transactional.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.transactional.isInTransaction();
    }

    @Override
    public void end() {
        this.transactional.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.transactional.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.transactional.transactionType();
    }

    public RDFLinkModular(LinkSparqlQuery queryConnection, LinkSparqlUpdate updateConnection, LinkDatasetGraph datasetConnection) {
        this.queryConnection = queryConnection;
        this.updateConnection = updateConnection;
        this.datasetConnection = datasetConnection;
        this.transactional = updateConnection != null ? updateConnection : (datasetConnection != null ? datasetConnection : (queryConnection != null ? queryConnection : null));
    }

    private RDFLinkModular(RDFLink connection) {
        this.queryConnection = connection;
        this.updateConnection = connection;
        this.datasetConnection = connection;
        this.transactional = connection;
    }

    public LinkSparqlQuery queryLink() {
        return this.queryConnection;
    }

    public LinkSparqlUpdate updateLink() {
        return this.updateConnection;
    }

    public LinkDatasetGraph datasetLink() {
        return this.datasetConnection;
    }

    private LinkSparqlQuery queryConnection() {
        if (this.queryConnection == null) {
            throw new UnsupportedOperationException("No LinkSparqlQuery");
        }
        return this.queryConnection;
    }

    private LinkSparqlUpdate updateConnection() {
        if (this.updateConnection == null) {
            throw new UnsupportedOperationException("No LinkSparqlUpdate");
        }
        return this.updateConnection;
    }

    private LinkDatasetGraph datasetConnection() {
        if (this.datasetConnection == null) {
            throw new UnsupportedOperationException("No LinkDatasetGraph");
        }
        return this.datasetConnection;
    }

    @Override
    public QueryExec query(Query query2) {
        return this.queryConnection().query(query2);
    }

    @Override
    public QueryExec query(String queryString) {
        return this.queryConnection().query(queryString);
    }

    @Override
    public QueryExecBuilder newQuery() {
        return this.queryConnection().newQuery();
    }

    @Override
    public UpdateExecBuilder newUpdate() {
        return this.updateConnection().newUpdate();
    }

    @Override
    public void update(UpdateRequest update2) {
        this.updateConnection().update(update2);
    }

    @Override
    public void load(Node graphName, String file) {
        this.datasetConnection().load(graphName, file);
    }

    @Override
    public void load(String file) {
        this.datasetConnection().load(file);
    }

    @Override
    public void load(Node graphName, Graph Graph2) {
        this.datasetConnection().load(graphName, Graph2);
    }

    @Override
    public void load(Graph Graph2) {
        this.datasetConnection().load(Graph2);
    }

    @Override
    public void put(Node graphName, String file) {
        this.datasetConnection().put(graphName, file);
    }

    @Override
    public void put(String file) {
        this.datasetConnection().put(file);
    }

    @Override
    public void put(Node graphName, Graph Graph2) {
        this.datasetConnection().put(graphName, Graph2);
    }

    @Override
    public void put(Graph Graph2) {
        this.datasetConnection().put(Graph2);
    }

    @Override
    public void delete(Node graphName) {
        this.datasetConnection().delete(graphName);
    }

    @Override
    public void delete() {
        this.datasetConnection().delete();
    }

    @Override
    public void loadDataset(String file) {
        this.datasetConnection().loadDataset(file);
    }

    @Override
    public void loadDataset(DatasetGraph dataset) {
        this.datasetConnection().loadDataset(dataset);
    }

    @Override
    public void putDataset(String file) {
        this.datasetConnection().putDataset(file);
    }

    @Override
    public void putDataset(DatasetGraph dataset) {
        this.datasetConnection().putDataset(dataset);
    }

    @Override
    public Graph get(Node graphName) {
        return this.datasetConnection.get(graphName);
    }

    @Override
    public Graph get() {
        return this.datasetConnection().get();
    }

    @Override
    public DatasetGraph getDataset() {
        return this.datasetConnection().getDataset();
    }

    @Override
    public void clearDataset() {
        this.datasetConnection().clearDataset();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
        if (this.queryConnection != null) {
            this.queryConnection.close();
        }
        if (this.updateConnection != null) {
            this.updateConnection.close();
        }
        if (this.datasetConnection != null) {
            this.datasetConnection.close();
        }
    }
}

