/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.util;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.ObjIntConsumer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.system.SystemListener;
import org.apache.sis.xml.bind.Context;

public final class XmlUtilities
extends SystemListener {
    private static volatile DatatypeFactory factory;
    private static final ChronoField[] FIELDS;
    private static final ObjIntConsumer<XMLGregorianCalendar>[] SETTERS;

    private XmlUtilities() {
        super("org.apache.sis.util");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            factory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        DatatypeFactory f = factory;
        if (f != null) return f;
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            f = factory;
            if (f != null) return f;
            factory = f = DatatypeFactory.newInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return f;
        }
    }

    public static boolean trimTime(XMLGregorianCalendar gc, boolean force) {
        if (force || gc.getMillisecond() == 0) {
            gc.setMillisecond(Integer.MIN_VALUE);
            if (force || gc.getHour() == 0 && gc.getMinute() == 0 && gc.getSecond() == 0) {
                gc.setHour(Integer.MIN_VALUE);
                gc.setMinute(Integer.MIN_VALUE);
                gc.setSecond(Integer.MIN_VALUE);
                gc.setTimezone(Integer.MIN_VALUE);
                return true;
            }
        }
        return false;
    }

    public static XMLGregorianCalendar toXML(Context context2, Temporal date2) throws DatatypeConfigurationException {
        if (date2 == null) {
            return null;
        }
        XMLGregorianCalendar xml = XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar();
        if (date2 instanceof Instant) {
            TimeZone zone = context2 != null ? context2.getTimeZone() : null;
            ZoneId zid = zone != null ? zone.toZoneId() : ZoneId.systemDefault();
            ZonedDateTime t = ZonedDateTime.ofInstant((Instant)date2, zid);
            for (int i = 0; i < FIELDS.length; ++i) {
                SETTERS[i].accept(xml, t.get(FIELDS[i]));
            }
        } else {
            for (int i = 0; i < FIELDS.length; ++i) {
                ChronoField field = FIELDS[i];
                if (!date2.isSupported(field)) continue;
                SETTERS[i].accept(xml, date2.get(field));
            }
        }
        return xml;
    }

    public static XMLGregorianCalendar toXML(Context context2, Date date2) throws DatatypeConfigurationException {
        if (date2 != null) {
            GregorianCalendar calendar = XmlUtilities.createGregorianCalendar(context2);
            calendar.setTime(date2);
            return XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(calendar);
        }
        return null;
    }

    private static GregorianCalendar createGregorianCalendar(Context context2) {
        if (context2 != null) {
            Locale locale = context2.getLocale();
            TimeZone timezone2 = context2.getTimeZone();
            if (timezone2 != null) {
                return locale != null ? new GregorianCalendar(timezone2, locale) : new GregorianCalendar(timezone2);
            }
            if (locale != null) {
                return new GregorianCalendar(locale);
            }
        }
        return new GregorianCalendar();
    }

    private static int zeroIfUndef(int value) {
        return value != Integer.MIN_VALUE ? value : 0;
    }

    public static Temporal toTemporal(Context context2, XMLGregorianCalendar xml) {
        boolean hasDate;
        if (xml == null) {
            return null;
        }
        int year = xml.getYear();
        int month = xml.getMonth();
        int day = xml.getDay();
        int hour = xml.getHour();
        int min2 = XmlUtilities.zeroIfUndef(xml.getMinute());
        int sec2 = XmlUtilities.zeroIfUndef(xml.getSecond());
        boolean hasYear = year != Integer.MIN_VALUE;
        boolean hasYM = hasYear && month != Integer.MIN_VALUE;
        boolean bl = hasDate = hasYM && day != Integer.MIN_VALUE;
        if (hour == Integer.MIN_VALUE) {
            return hasDate ? LocalDate.of(year, month, day) : (hasYM ? YearMonth.of(year, month) : (hasYear ? Year.of(year) : null));
        }
        BigDecimal f = xml.getFractionalSecond();
        int nano = f != null ? f.movePointRight(9).intValue() : 0;
        int offset = xml.getTimezone();
        if (offset == Integer.MIN_VALUE) {
            if (hasDate) {
                return LocalDateTime.of(year, month, day, hour, min2, sec2, nano);
            }
            return LocalTime.of(hour, min2, sec2, nano);
        }
        ZoneOffset zone = ZoneOffset.ofTotalSeconds(offset * 60);
        if (hasDate) {
            return OffsetDateTime.of(year, month, day, hour, min2, sec2, nano, zone);
        }
        return OffsetTime.of(hour, min2, sec2, nano, zone);
    }

    public static Date toDate(Context context2, XMLGregorianCalendar xml) {
        if (xml != null) {
            TimeZone timezone2;
            GregorianCalendar calendar = xml.toGregorianCalendar();
            if (context2 != null && xml.getTimezone() == Integer.MIN_VALUE && (timezone2 = context2.getTimeZone()) != null) {
                calendar.setTimeZone(timezone2);
            }
            return calendar.getTime();
        }
        return null;
    }

    static {
        SystemListener.add(new XmlUtilities());
        FIELDS = new ChronoField[]{ChronoField.YEAR, ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS};
        SETTERS = new ObjIntConsumer[FIELDS.length];
        XmlUtilities.SETTERS[0] = XMLGregorianCalendar::setYear;
        XmlUtilities.SETTERS[1] = XMLGregorianCalendar::setMonth;
        XmlUtilities.SETTERS[2] = XMLGregorianCalendar::setDay;
        XmlUtilities.SETTERS[3] = XMLGregorianCalendar::setHour;
        XmlUtilities.SETTERS[4] = XMLGregorianCalendar::setMinute;
        XmlUtilities.SETTERS[5] = XMLGregorianCalendar::setSecond;
        XmlUtilities.SETTERS[6] = XMLGregorianCalendar::setMillisecond;
        XmlUtilities.SETTERS[7] = (calendar, seconds) -> calendar.setTimezone(seconds / 60);
    }
}

