/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import org.apache.jena.fuseki.access.AssemblerAccessDataset;
import org.apache.jena.fuseki.access.AssemblerSecurityRegistry;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.system.Vocab;

public class VocabSecurity {
    private static final String NS = "http://jena.apache.org/access#";
    public static final Resource tAccessControlledDataset = Vocab.type("http://jena.apache.org/access#", "AccessControlledDataset");
    public static final Resource tSecurityRegistry = Vocab.type("http://jena.apache.org/access#", "SecurityRegistry");
    public static final Property pDataset = Vocab.property("http://jena.apache.org/access#", "dataset");
    public static final Property pSecurityRegistry = Vocab.property("http://jena.apache.org/access#", "registry");
    public static final Property pEntry = Vocab.property("http://jena.apache.org/access#", "entry");
    public static final Property pUser = Vocab.property("http://jena.apache.org/access#", "user");
    public static final Property pGraphs = Vocab.property("http://jena.apache.org/access#", "graphs");
    private static boolean initialized = false;

    public static String getURI() {
        return NS;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        AssemblerUtils.registerDataset(tAccessControlledDataset, new AssemblerAccessDataset());
        AssemblerUtils.registerModel(tSecurityRegistry, new AssemblerSecurityRegistry());
    }

    static {
        VocabSecurity.init();
    }
}

