/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.reader.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.lang.extra.LangParserLib;
import org.apache.jena.shacl.compact.reader.ShaclCompactParser;
import org.apache.jena.shacl.compact.reader.parser.ParseException;
import org.apache.jena.shacl.compact.reader.parser.ShaclCompactParserJJConstants;
import org.apache.jena.shacl.compact.reader.parser.ShaclCompactParserJJTokenManager;
import org.apache.jena.shacl.compact.reader.parser.SimpleCharStream;
import org.apache.jena.shacl.compact.reader.parser.Token;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;

public class ShaclCompactParserJJ
extends ShaclCompactParser
implements ShaclCompactParserJJConstants {
    public ShaclCompactParserJJTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[40];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    public final void Unit() throws ParseException {
        this.ByteOrderMark();
        this.shaclDoc();
        this.jj_consume_token(0);
    }

    public final void ByteOrderMark() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
    }

    public final void shaclDoc() throws ParseException {
        block12: {
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 53: 
                    case 54: 
                    case 55: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block10;
                    }
                }
                this.directive();
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 56: 
                    case 57: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 57: {
                        this.nodeShape();
                        continue block11;
                    }
                    case 56: {
                        this.shapeClass();
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void directive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 53: {
                this.baseDecl();
                break;
            }
            case 55: {
                this.prefixDecl();
                break;
            }
            case 54: {
                this.importDecl();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void baseDecl() throws ParseException {
        this.jj_consume_token(53);
        String iri = this.IRIREF();
        this.rBase(iri);
    }

    public final void prefixDecl() throws ParseException {
        this.jj_consume_token(55);
        Token t = this.jj_consume_token(80);
        String iri = this.IRIREF();
        String s = this.canonicalPrefix(t.image, t.beginLine, t.beginColumn);
        this.rPrefix(s, iri);
    }

    public final void importDecl() throws ParseException {
        this.jj_consume_token(54);
        String iri = this.iri();
        this.rImports(iri);
    }

    public final void nodeShape() throws ParseException {
        this.startNodeShape();
        this.jj_consume_token(57);
        String iri = this.iri();
        this.rNodeShape(iri);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: {
                this.targetClass();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        this.nodeShapeBody();
        this.finishNodeShape();
    }

    public final void shapeClass() throws ParseException {
        this.startShapeClass();
        this.jj_consume_token(56);
        String iri = this.iri();
        this.rShapeClass(iri);
        this.nodeShapeBody();
        this.finishShapeClass();
    }

    public final void targetClass() throws ParseException {
        this.jj_consume_token(1);
        block3: while (true) {
            String iri = this.iri();
            this.rTargetClass(iri);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 79: 
                case 80: 
                case 81: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[6] = this.jj_gen;
    }

    public final void nodeShapeBody() throws ParseException {
        this.startNodeShapeBody();
        this.jj_consume_token(75);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 65: 
                case 66: 
                case 68: 
                case 73: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.constraint();
        }
        this.jj_consume_token(76);
        this.finishNodeShapeBody();
    }

    public final void constraint() throws ParseException {
        this.startConstraint();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 68: {
                block8: while (true) {
                    this.nodeOr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 68: {
                            continue block8;
                        }
                    }
                    break;
                }
                this.jj_la1[8] = this.jj_gen;
                break;
            }
            case 66: 
            case 73: 
            case 79: 
            case 80: 
            case 81: {
                this.propertyShape();
                break;
            }
            case 65: 
            case 82: 
            case 83: {
                this.shapeRef(false);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.finishConstraint();
        this.jj_consume_token(67);
    }

    public final void nodeOr() throws ParseException {
        this.startNodeOr();
        this.rNodeOr_pre();
        this.nodeNot();
        this.rNodeOr_post();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            this.rNodeOr_pre();
            this.nodeNot();
            this.rNodeOr_post();
        }
        this.finishNodeOr();
    }

    public final void nodeNot() throws ParseException {
        boolean b = false;
        this.startNodeNot();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 68: {
                this.negation();
                b = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.beginNodeNot(b);
        this.nodeValue();
        this.finishNodeNot(b);
    }

    public final void negation() throws ParseException {
        this.jj_consume_token(68);
    }

    public final void nodeValue() throws ParseException {
        String s = this.nodeParam();
        this.jj_consume_token(72);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 58: 
            case 59: 
            case 79: 
            case 80: 
            case 81: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: {
                Node n = this.iriOrLiteral();
                this.rNodeValue(s, n);
                break;
            }
            case 77: {
                List<Node> x = this.array();
                this.rNodeValue(s, x);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void propertyShape() throws ParseException {
        block8: {
            this.startPropertyShape();
            Path p = this.path();
            this.rPropertyShape(p);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 65: 
                    case 68: 
                    case 75: 
                    case 77: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 77: {
                        this.propertyCount();
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 65: 
                    case 68: 
                    case 75: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: {
                        this.propertyOr();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.finishPropertyShape();
    }

    public final void propertyOr() throws ParseException {
        this.startPropertyOr();
        this.rPropertyOr_pre();
        this.propertyNot();
        this.rPropertyOr_post();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            this.rPropertyOr_pre();
            this.propertyNot();
            this.rPropertyOr_post();
        }
        this.finishPropertyOr();
    }

    public final void propertyNot() throws ParseException {
        boolean b = false;
        this.startPropertyNot();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 68: {
                this.negation();
                b = true;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        this.beginPropertyNot(b);
        this.propertyAtom();
        this.finishPropertyNot(b);
    }

    public final void propertyAtom() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: 
            case 80: 
            case 81: {
                this.propertyType();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.nodeKind();
                break;
            }
            case 65: 
            case 82: 
            case 83: {
                this.shapeRef(true);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.propertyValue();
                break;
            }
            case 75: {
                this.startNestedPropertyAtom();
                this.nodeShapeBody();
                this.finishNestedPropertyAtom();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void propertyCount() throws ParseException {
        this.jj_consume_token(77);
        String s1 = this.propertyMinCount();
        this.jj_consume_token(2);
        String s2 = this.propertyMaxCount();
        this.jj_consume_token(78);
        this.rPropertyCount(s1, s2);
    }

    public final String propertyMinCount() throws ParseException {
        Token t = this.jj_consume_token(95);
        return t.image;
    }

    public final String propertyMaxCount() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 95 -> this.jj_consume_token(95);
            case 71 -> this.jj_consume_token(71);
            default -> {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return t.image;
    }

    public final void propertyType() throws ParseException {
        String iriStr = this.iri();
        this.rPropertyType(iriStr);
    }

    public final void nodeKind() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 3 -> this.jj_consume_token(3);
            case 4 -> this.jj_consume_token(4);
            case 5 -> this.jj_consume_token(5);
            case 6 -> this.jj_consume_token(6);
            case 7 -> this.jj_consume_token(7);
            case 8 -> this.jj_consume_token(8);
            default -> {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        this.rNodeKind(t.image);
    }

    public final void shapeRef(boolean inPropertyShape) throws ParseException {
        this.rShapeRef(inPropertyShape, switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 83 -> {
                Token t = this.jj_consume_token(83);
                yield this.resolvePName(t.image.substring(1), t.beginLine, t.beginColumn);
            }
            case 82 -> {
                Token t = this.jj_consume_token(82);
                yield this.resolvePName(t.image.substring(1), t.beginLine, t.beginColumn);
            }
            case 65 -> {
                this.jj_consume_token(65);
                yield this.IRIREF();
            }
            default -> {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        });
    }

    public final void propertyValue() throws ParseException {
        String s = this.propertyParam();
        this.jj_consume_token(72);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 58: 
            case 59: 
            case 79: 
            case 80: 
            case 81: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: {
                Node n = this.iriOrLiteral();
                this.rParamValue(s, n);
                break;
            }
            case 77: {
                List<Node> x = this.array();
                this.rParamValue(s, x);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String nodeParam() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9 -> this.jj_consume_token(9);
            case 10 -> this.jj_consume_token(10);
            case 11 -> this.jj_consume_token(11);
            case 12 -> this.jj_consume_token(12);
            case 13 -> this.jj_consume_token(13);
            case 14 -> this.jj_consume_token(14);
            case 15 -> this.jj_consume_token(15);
            case 16 -> this.jj_consume_token(16);
            case 17 -> this.jj_consume_token(17);
            case 18 -> this.jj_consume_token(18);
            case 19 -> this.jj_consume_token(19);
            case 20 -> this.jj_consume_token(20);
            case 21 -> this.jj_consume_token(21);
            case 22 -> this.jj_consume_token(22);
            case 23 -> this.jj_consume_token(23);
            case 24 -> this.jj_consume_token(24);
            case 25 -> this.jj_consume_token(25);
            case 26 -> this.jj_consume_token(26);
            case 27 -> this.jj_consume_token(27);
            case 28 -> this.jj_consume_token(28);
            case 29 -> this.jj_consume_token(29);
            case 30 -> this.jj_consume_token(30);
            case 31 -> this.jj_consume_token(31);
            case 32 -> this.jj_consume_token(32);
            case 33 -> this.jj_consume_token(33);
            default -> {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return t.image;
    }

    public final String propertyParam() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13 -> this.jj_consume_token(13);
            case 14 -> this.jj_consume_token(14);
            case 15 -> this.jj_consume_token(15);
            case 16 -> this.jj_consume_token(16);
            case 17 -> this.jj_consume_token(17);
            case 18 -> this.jj_consume_token(18);
            case 19 -> this.jj_consume_token(19);
            case 20 -> this.jj_consume_token(20);
            case 21 -> this.jj_consume_token(21);
            case 22 -> this.jj_consume_token(22);
            case 23 -> this.jj_consume_token(23);
            case 24 -> this.jj_consume_token(24);
            case 25 -> this.jj_consume_token(25);
            case 26 -> this.jj_consume_token(26);
            case 27 -> this.jj_consume_token(27);
            case 34 -> this.jj_consume_token(34);
            case 28 -> this.jj_consume_token(28);
            case 29 -> this.jj_consume_token(29);
            case 35 -> this.jj_consume_token(35);
            case 36 -> this.jj_consume_token(36);
            case 37 -> this.jj_consume_token(37);
            case 38 -> this.jj_consume_token(38);
            case 39 -> this.jj_consume_token(39);
            case 40 -> this.jj_consume_token(40);
            case 30 -> this.jj_consume_token(30);
            case 31 -> this.jj_consume_token(31);
            case 32 -> this.jj_consume_token(32);
            case 33 -> this.jj_consume_token(33);
            case 41 -> this.jj_consume_token(41);
            case 42 -> this.jj_consume_token(42);
            case 43 -> this.jj_consume_token(43);
            case 44 -> this.jj_consume_token(44);
            case 45 -> this.jj_consume_token(45);
            default -> {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return t.image;
    }

    public final Path PathUnit() throws ParseException {
        this.ByteOrderMark();
        Path p = this.path();
        this.jj_consume_token(0);
        return p;
    }

    public final Path path() throws ParseException {
        Path p = this.pathAlternative();
        return p;
    }

    public final Path pathAlternative() throws ParseException {
        Path p1 = this.pathSequence();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            Path p2 = this.pathSequence();
            p1 = PathFactory.pathAlt((Path)p1, (Path)p2);
        }
        return p1;
    }

    public final Path pathSequence() throws ParseException {
        Path p1 = this.pathEltOrInverse();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 70: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(70);
            Path p2 = this.pathEltOrInverse();
            p1 = PathFactory.pathSeq((Path)p1, (Path)p2);
        }
        return p1;
    }

    public final Path pathElt() throws ParseException {
        Path p = this.pathPrimary();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 62: 
            case 69: 
            case 71: {
                p = this.pathMod(p);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        return p;
    }

    public final Path pathEltOrInverse() throws ParseException {
        Path p;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 73: 
            case 79: 
            case 80: 
            case 81: {
                p = this.pathElt();
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                p = this.pathElt();
                p = PathFactory.pathInverse((Path)p);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return p;
    }

    public final Path pathMod(Path p) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                return PathFactory.pathZeroOrOne((Path)p);
            }
            case 71: {
                this.jj_consume_token(71);
                return PathFactory.pathZeroOrMore1((Path)p);
            }
            case 62: {
                this.jj_consume_token(62);
                return PathFactory.pathOneOrMore1((Path)p);
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Path pathPrimary() throws ParseException {
        Path p;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: 
            case 80: 
            case 81: {
                String str = this.iri();
                Node n = this.createURI(str, this.token.beginLine, this.token.beginColumn);
                p = PathFactory.pathLink((Node)n);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                p = this.path();
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return p;
    }

    public final List<Node> array() throws ParseException {
        ArrayList<Node> x = new ArrayList<Node>();
        Node n = null;
        this.jj_consume_token(77);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 58: 
                case 59: 
                case 79: 
                case 80: 
                case 81: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 95: 
                case 96: 
                case 97: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            n = this.iriOrLiteral();
            x.add(n);
        }
        this.jj_consume_token(78);
        return x;
    }

    public final Node iriOrLiteral() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79, 80, 81 -> {
                String uriStr = this.iri();
                yield this.createURI(uriStr, this.token.beginLine, this.token.beginColumn);
            }
            case 58, 59, 90, 91, 92, 93, 95, 96, 97 -> this.literal();
            default -> {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node literal() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90, 91, 92, 93 -> this.rdfLiteral();
            case 95, 96, 97 -> this.numericLiteral();
            case 58, 59 -> this.booleanLiteral();
            default -> {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node booleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                return this.XSD_TRUE;
            }
            case 59: {
                this.jj_consume_token(59);
                return this.XSD_FALSE;
            }
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node numericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 95: {
                Token t = this.jj_consume_token(95);
                return this.createLiteralInteger(t.image, this.token.beginLine, this.token.beginColumn);
            }
            case 96: {
                Token t = this.jj_consume_token(96);
                return this.createLiteralDecimal(t.image, this.token.beginLine, this.token.beginColumn);
            }
            case 97: {
                Token t = this.jj_consume_token(97);
                return this.createLiteralDouble(t.image, this.token.beginLine, this.token.beginColumn);
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node rdfLiteral() throws ParseException {
        String lex = null;
        lex = this.string();
        Token t = this.token;
        String lang = null;
        String dt = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: 
            case 99: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 99: {
                        Token tLang = this.jj_consume_token(99);
                        lang = LangParserLib.stripChars((String)tLang.image, (int)1);
                        break block0;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        dt = this.datatype();
                        break block0;
                    }
                }
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        return this.createLiteral(lex, lang, dt, t.beginLine, t.beginColumn);
    }

    public final String datatype() throws ParseException {
        String s = this.iri();
        return s;
    }

    public final String string() throws ParseException {
        Token t;
        String lex = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90 -> {
                t = this.jj_consume_token(90);
                yield LangParserLib.stripQuotes((String)t.image);
            }
            case 91 -> {
                t = this.jj_consume_token(91);
                yield LangParserLib.stripQuotes((String)t.image);
            }
            case 92 -> {
                t = this.jj_consume_token(92);
                yield LangParserLib.stripQuotes3((String)t.image);
            }
            case 93 -> {
                t = this.jj_consume_token(93);
                yield LangParserLib.stripQuotes3((String)t.image);
            }
            default -> {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        lex = LangParserLib.unescapeStr((String)lex, (int)t.beginLine, (int)t.beginColumn);
        return lex;
    }

    public final String iri() throws ParseException {
        String iri = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                iri = this.IRIREF();
                return iri;
            }
            case 80: 
            case 81: {
                iri = this.PrefixedName();
                return iri;
            }
        }
        this.jj_la1[38] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String PrefixedName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 81: {
                Token t = this.jj_consume_token(81);
                return this.resolvePName(t.image, t.beginLine, t.beginColumn);
            }
            case 80: {
                Token t = this.jj_consume_token(80);
                return this.resolvePName(t.image, t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[39] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String IRIREF() throws ParseException {
        Token t = this.jj_consume_token(79);
        return this.resolveQuotedIRI(t.image, t.beginLine, t.beginColumn);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 2, 0, -512, -512, -512, 0, 0, 0, -7688, -7688, 0, 0, -7688, 0, 504, 0, 0, -512, -8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x10000000, 0xE00000, 0x3000000, 0x3000000, 0xE00000, 0, 0, 3, 3, 3, 0, 0, 0xC000000, 16383, 16383, 0, 0, 16383, 0, 0, 0, 0xC000000, 3, 16383, 0, 0, 0x40000000, 0, 0x40000000, 0, 0xC000000, 0xC000000, 0xC000000, 0xC000000, 0, 16384, 16384, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 229376, 1016342, 16, 1016342, 1, 16, -1140613120, 1026066, 1026066, 1, 16, 1017858, -2147483520, 0, 786434, -1140613120, 0, 0, 1, 64, 160, 229892, 160, 229888, -1140621312, -1140621312, -1140850688, 0, Integer.MIN_VALUE, 0, 0, 0x3C000000, 229376, 196608};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 3, 8, 8, 0, 0, 0};
    }

    public ShaclCompactParserJJ(InputStream stream) {
        this(stream, null);
    }

    public ShaclCompactParserJJ(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ShaclCompactParserJJTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 40; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 40; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ShaclCompactParserJJ(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ShaclCompactParserJJTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 40; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ShaclCompactParserJJTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 40; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ShaclCompactParserJJ(ShaclCompactParserJJTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 40; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ShaclCompactParserJJTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 40; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[113];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 40; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 113; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ShaclCompactParserJJ.jj_la1_init_0();
        ShaclCompactParserJJ.jj_la1_init_1();
        ShaclCompactParserJJ.jj_la1_init_2();
        ShaclCompactParserJJ.jj_la1_init_3();
    }
}

