/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.dto.SerializableReIndexingExecutionFailures;
import org.apache.mailbox.tools.indexer.ErrorRecoveryIndexationTask;
import org.apache.mailbox.tools.indexer.FullReindexingTask;
import org.apache.mailbox.tools.indexer.ReIndexingContextInformationDTO;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;

public class WebAdminIndexationContextInformationDTO
implements AdditionalInformationDTO {
    protected final String type;
    protected final RunningOptionsDTO runningOptions;
    protected final int successfullyReprocessedMailCount;
    protected final int failedReprocessedMailCount;
    protected final SerializableReIndexingExecutionFailures messageFailures;
    private final List<String> mailboxFailures;
    protected final Instant timestamp;

    WebAdminIndexationContextInformationDTO(String type, RunningOptionsDTO runningOptions, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
        this.type = type;
        this.runningOptions = runningOptions;
        this.successfullyReprocessedMailCount = successfullyReprocessedMailCount;
        this.failedReprocessedMailCount = failedReprocessedMailCount;
        this.messageFailures = SerializableReIndexingExecutionFailures.from(failures);
        this.mailboxFailures = (List)failures.mailboxFailures().stream().map(MailboxId::serialize).collect(ImmutableList.toImmutableList());
        this.timestamp = timestamp;
    }

    public RunningOptionsDTO getRunningOptions() {
        return this.runningOptions;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.successfullyReprocessedMailCount;
    }

    public int getFailedReprocessedMailCount() {
        return this.failedReprocessedMailCount;
    }

    public SerializableReIndexingExecutionFailures getMessageFailures() {
        return this.messageFailures;
    }

    public List<String> getMailboxFailures() {
        return this.mailboxFailures;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public static class WebAdminFullIndexationDTO
    extends WebAdminIndexationContextInformationDTO {
        public static AdditionalInformationDTOModule<ReIndexingContextInformationDTO.ReIndexingContextInformationForFullReindexingTask, WebAdminFullIndexationDTO> serializationModule() {
            return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReIndexingContextInformationDTO.ReIndexingContextInformationForFullReindexingTask.class).convertToDTO(WebAdminFullIndexationDTO.class).toDomainObjectConverter(dto -> {
                throw new NotImplementedException("Deserialization not implemented for this DTO");
            }).toDTOConverter((details, type) -> new WebAdminFullIndexationDTO(type, RunningOptionsDTO.toDTO((ReIndexer.RunningOptions)details.getRunningOptions()), details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), details.failures(), details.timestamp())).typeName(FullReindexingTask.FULL_RE_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
        }

        WebAdminFullIndexationDTO(String type, RunningOptionsDTO runningOptions, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
            super(type, runningOptions, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
        }
    }

    public static class WebAdminErrorRecoveryIndexationDTO
    extends WebAdminIndexationContextInformationDTO {
        public static AdditionalInformationDTOModule<ReIndexingContextInformationDTO.ReIndexingContextInformationForErrorRecoveryIndexationTask, WebAdminErrorRecoveryIndexationDTO> serializationModule() {
            return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReIndexingContextInformationDTO.ReIndexingContextInformationForErrorRecoveryIndexationTask.class).convertToDTO(WebAdminErrorRecoveryIndexationDTO.class).toDomainObjectConverter(dto -> {
                throw new NotImplementedException("Deserialization not implemented for this DTO");
            }).toDTOConverter((details, type) -> new WebAdminErrorRecoveryIndexationDTO(type, RunningOptionsDTO.toDTO((ReIndexer.RunningOptions)details.getRunningOptions()), details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), details.failures(), details.timestamp())).typeName(ErrorRecoveryIndexationTask.PREVIOUS_FAILURES_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
        }

        WebAdminErrorRecoveryIndexationDTO(String type, RunningOptionsDTO runningOptionsDTO, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
            super(type, runningOptionsDTO, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
        }
    }
}

