/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class DefaultMetricId
implements MetricId {
    private final String name;
    private final ImmutableMap<String, String> tags;

    public DefaultMetricId(String name, Map<String, String> tags) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.tags = ImmutableMap.copyOf(Objects.requireNonNull(tags, "tags cannot be null"));
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMetricId that = (DefaultMetricId)o;
        return this.name.equals(that.name) && this.tags.equals(that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }

    public String toString() {
        return this.name + this.tags;
    }
}

