/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.buffer;

import com.datastax.shaded.netty.buffer.ByteBuf;
import com.datastax.shaded.netty.buffer.CompositeByteBuf;
import com.datastax.shaded.netty.buffer.SimpleLeakAwareByteBuf;
import com.datastax.shaded.netty.buffer.WrappedCompositeByteBuf;
import com.datastax.shaded.netty.util.ResourceLeakTracker;
import com.datastax.shaded.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

class SimpleLeakAwareCompositeByteBuf
extends WrappedCompositeByteBuf {
    final ResourceLeakTracker<ByteBuf> leak;

    SimpleLeakAwareCompositeByteBuf(CompositeByteBuf wrapped, ResourceLeakTracker<ByteBuf> leak) {
        super(wrapped);
        this.leak = ObjectUtil.checkNotNull(leak, "leak");
    }

    @Override
    public boolean release() {
        ByteBuf unwrapped = this.unwrap();
        if (super.release()) {
            this.closeLeak(unwrapped);
            return true;
        }
        return false;
    }

    @Override
    public boolean release(int decrement) {
        ByteBuf unwrapped = this.unwrap();
        if (super.release(decrement)) {
            this.closeLeak(unwrapped);
            return true;
        }
        return false;
    }

    private void closeLeak(ByteBuf trackedByteBuf) {
        boolean closed = this.leak.close(trackedByteBuf);
        assert (closed);
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        if (this.order() == endianness) {
            return this;
        }
        return this.newLeakAwareByteBuf(super.order(endianness));
    }

    @Override
    public ByteBuf slice() {
        return this.newLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf slice(int index, int length) {
        return this.newLeakAwareByteBuf(super.slice(index, length));
    }

    @Override
    public ByteBuf duplicate() {
        return this.newLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf readSlice(int length) {
        return this.newLeakAwareByteBuf(super.readSlice(length));
    }

    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf wrapped) {
        return this.newLeakAwareByteBuf(wrapped, this.unwrap(), this.leak);
    }

    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf wrapped, ByteBuf trackedByteBuf, ResourceLeakTracker<ByteBuf> leakTracker) {
        return new SimpleLeakAwareByteBuf(wrapped, trackedByteBuf, leakTracker);
    }
}

