/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.metadata.StorageInformation;
import reactor.core.publisher.Mono;

public class StorageInformationDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement removeStatement;
    private final PreparedStatement readStatement;
    private final BlobId.Factory blobIdFactory;

    @Inject
    StorageInformationDAO(Session session, BlobId.Factory blobIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAdd(session);
        this.removeStatement = this.prepareRemove(session);
        this.readStatement = this.prepareRead(session);
        this.blobIdFactory = blobIdFactory;
    }

    private PreparedStatement prepareRead(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"bucketName", "blobId"}).from("storageInformation").where(QueryBuilder.eq((String)"owner", (Object)QueryBuilder.bindMarker((String)"owner"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareRemove(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("storageInformation").where(QueryBuilder.eq((String)"owner", (Object)QueryBuilder.bindMarker((String)"owner"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareAdd(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"storageInformation").value("owner", (Object)QueryBuilder.bindMarker((String)"owner")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName")).value("blobId", (Object)QueryBuilder.bindMarker((String)"blobId")));
    }

    Mono<Void> referenceStorageInformation(Username username, MessageId messageId, StorageInformation storageInformation) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.addStatement.bind().setString("owner", username.asString()).setString("messageId", messageId.serialize()).setString("bucketName", storageInformation.getBucketName().asString()).setString("blobId", storageInformation.getBlobId().asString()));
    }

    Mono<Void> deleteStorageInformation(Username username, MessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.removeStatement.bind().setString("owner", username.asString()).setString("messageId", messageId.serialize()));
    }

    Mono<StorageInformation> retrieveStorageInformation(Username username, MessageId messageId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.readStatement.bind().setString("owner", username.asString()).setString("messageId", messageId.serialize())).map(row -> StorageInformation.builder().bucketName(BucketName.of((String)row.getString("bucketName"))).blobId(this.blobIdFactory.from(row.getString("blobId"))));
    }
}

