/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.cassandra.upload.UploadConfiguration;
import org.apache.james.mailbox.model.ContentType;
import reactor.core.publisher.Mono;

public class UploadDAO {
    private final CassandraAsyncExecutor executor;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement insert;
    private final PreparedStatement selectOne;

    @Inject
    public UploadDAO(Session session, BlobId.Factory blobIdFactory, UploadConfiguration configuration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.blobIdFactory = blobIdFactory;
        this.insert = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"uploads").value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("bucket_id", (Object)QueryBuilder.bindMarker((String)"bucket_id")).value("blob_id", (Object)QueryBuilder.bindMarker((String)"blob_id")).value("size", (Object)QueryBuilder.bindMarker((String)"size")).value("user", (Object)QueryBuilder.bindMarker((String)"user")).value("content_type", (Object)QueryBuilder.bindMarker((String)"content_type")).using(QueryBuilder.ttl((int)((int)configuration.getUploadTtlDuration().getSeconds()))));
        this.selectOne = session.prepare((RegularStatement)QueryBuilder.select().from("uploads").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    public Mono<Void> save(UploadRepresentation uploadRepresentation) {
        return this.executor.executeVoid((Statement)this.insert.bind().setUUID("id", uploadRepresentation.getId().getId()).setString("bucket_id", uploadRepresentation.getBucketName().asString()).setString("blob_id", uploadRepresentation.getBlobId().asString()).setLong("size", uploadRepresentation.getSize()).setString("user", uploadRepresentation.getUser().asString()).setString("content_type", uploadRepresentation.getContentType().asString()));
    }

    public Mono<UploadRepresentation> retrieve(UploadId id) {
        return this.executor.executeSingleRow((Statement)this.selectOne.bind().setUUID("id", id.getId())).map(row -> new UploadRepresentation(id, BucketName.of((String)row.getString("bucket_id")), this.blobIdFactory.from(row.getString("blob_id")), ContentType.of((String)row.getString("content_type")), row.getLong("size"), Username.of((String)row.getString("user"))));
    }

    public static class UploadRepresentation {
        private final UploadId id;
        private final BucketName bucketName;
        private final BlobId blobId;
        private final ContentType contentType;
        private final long size;
        private final Username user;

        public UploadRepresentation(UploadId id, BucketName bucketName, BlobId blobId, ContentType contentType, long size, Username user) {
            this.user = user;
            Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Size must be strictly positive");
            this.id = id;
            this.bucketName = bucketName;
            this.blobId = blobId;
            this.contentType = contentType;
            this.size = size;
        }

        public UploadId getId() {
            return this.id;
        }

        public BucketName getBucketName() {
            return this.bucketName;
        }

        public BlobId getBlobId() {
            return this.blobId;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public long getSize() {
            return this.size;
        }

        public Username getUser() {
            return this.user;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UploadRepresentation) {
                UploadRepresentation other = (UploadRepresentation)obj;
                return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.bucketName, (Object)other.bucketName) && Objects.equal((Object)this.user, (Object)other.user) && Objects.equal((Object)this.blobId, (Object)other.blobId) && Objects.equal((Object)this.contentType, (Object)other.contentType) && Objects.equal((Object)this.size, (Object)other.size);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.bucketName, this.blobId, this.contentType, this.size, this.user});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("bucketName", (Object)this.bucketName).add("blobId", (Object)this.blobId).add("contentType", (Object)this.contentType).add("user", (Object)this.user).add("size", this.size).toString();
        }
    }
}

