/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.jmap.draft.model.Property;

public class MessageProperties {
    public static final ImmutableSet<MessageProperty> MANDATORY_PROPERTIES = ImmutableSet.of((Object)MessageProperty.id);
    private final Optional<ImmutableSet<MessageProperty>> messageProperties;
    private final Optional<ImmutableSet<HeaderProperty>> headersProperties;

    public MessageProperties(Optional<ImmutableSet<String>> properties) {
        this.messageProperties = properties.map(this::toMessageProperties);
        this.headersProperties = properties.map(this::toHeadersProperties);
    }

    private MessageProperties(Optional<ImmutableSet<MessageProperty>> messageProperties, Optional<ImmutableSet<HeaderProperty>> headersProperties) {
        this.messageProperties = messageProperties;
        this.headersProperties = headersProperties;
    }

    private ImmutableSet<MessageProperty> toMessageProperties(ImmutableSet<String> properties) {
        return (ImmutableSet)properties.stream().flatMap(MessageProperty::find).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<HeaderProperty> toHeadersProperties(ImmutableSet<String> properties) {
        return (ImmutableSet)properties.stream().flatMap(HeaderProperty::find).collect(ImmutableSet.toImmutableSet());
    }

    public Optional<ImmutableSet<HeaderProperty>> getOptionalHeadersProperties() {
        return this.headersProperties;
    }

    public Optional<ImmutableSet<MessageProperty>> getOptionalMessageProperties() {
        return this.messageProperties;
    }

    public MessageProperties toOutputProperties() {
        return this.ensureContains(MANDATORY_PROPERTIES).selectBody().overrideHeadersFilteringOnHeadersMessageProperty().ensureHeadersMessageProperty();
    }

    public ReadProfile computeReadLevel() {
        Stream<ReadProfile> readLevels = Stream.concat(this.buildOutputMessageProperties().stream().map(MessageProperty::getReadProfile), this.headerPropertiesReadLevel());
        return readLevels.reduce(ReadProfile::combine).orElse(ReadProfile.Full);
    }

    public Stream<String> asFieldList() {
        return Stream.concat(this.messageProperties.stream().flatMap(Collection::stream).map(MessageProperty::asFieldName), this.headersProperties.stream().flatMap(Collection::stream).map(HeaderProperty::asFieldName));
    }

    private Stream<ReadProfile> headerPropertiesReadLevel() {
        return this.headersProperties.map(collection -> collection.stream().map(any -> ReadProfile.Header)).orElse(Stream.of(new ReadProfile[0]));
    }

    private ImmutableSet<MessageProperty> buildOutputMessageProperties() {
        return this.messageProperties.orElseGet(MessageProperty::allOutputProperties);
    }

    private MessageProperties usingProperties(Sets.SetView<MessageProperty> properties) {
        return new MessageProperties(Optional.of(properties.immutableCopy()), this.headersProperties);
    }

    private MessageProperties ensureContains(ImmutableSet<MessageProperty> mandatoryFields) {
        return this.usingProperties((Sets.SetView<MessageProperty>)Sets.union(this.buildOutputMessageProperties(), mandatoryFields));
    }

    private MessageProperties selectBody() {
        ImmutableSet<MessageProperty> messageProperties = this.buildOutputMessageProperties();
        if (messageProperties.contains((Object)MessageProperty.body)) {
            return this.usingProperties((Sets.SetView<MessageProperty>)Sets.difference((Set)Sets.union(messageProperties, (Set)ImmutableSet.of((Object)MessageProperty.textBody)), (Set)ImmutableSet.of((Object)MessageProperty.body)));
        }
        return this;
    }

    private MessageProperties ensureHeadersMessageProperty() {
        if (this.headersProperties.isPresent() && !this.headersProperties.get().isEmpty()) {
            return this.usingProperties((Sets.SetView<MessageProperty>)Sets.union(this.buildOutputMessageProperties(), (Set)ImmutableSet.of((Object)MessageProperty.headers)));
        }
        return this;
    }

    private MessageProperties overrideHeadersFilteringOnHeadersMessageProperty() {
        if (this.buildOutputMessageProperties().contains((Object)MessageProperty.headers)) {
            return new MessageProperties(this.messageProperties, Optional.empty());
        }
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("headersProperties", this.headersProperties).add("messageProperties", this.messageProperties).toString();
    }

    public static class HeaderProperty
    implements Property {
        public static final String HEADER_PROPERTY_PREFIX = "headers.";
        private String fieldName;

        public static HeaderProperty fromFieldName(String field) {
            Preconditions.checkArgument((!HeaderProperty.isMessageHeaderProperty(field) ? 1 : 0) != 0);
            return new HeaderProperty(field.toLowerCase(Locale.US));
        }

        public static HeaderProperty valueOf(String property) {
            Preconditions.checkArgument((boolean)HeaderProperty.isMessageHeaderProperty(property));
            return new HeaderProperty(HeaderProperty.stripPrefix(property).toLowerCase(Locale.US));
        }

        private static String stripPrefix(String property) {
            return property.substring(HEADER_PROPERTY_PREFIX.length());
        }

        public static boolean isMessageHeaderProperty(String property) {
            Preconditions.checkNotNull((Object)property);
            return property.startsWith(HEADER_PROPERTY_PREFIX);
        }

        public static Stream<HeaderProperty> find(String property) {
            if (HeaderProperty.isMessageHeaderProperty(property)) {
                return Stream.of(HeaderProperty.valueOf(property));
            }
            return Stream.of(new HeaderProperty[0]);
        }

        private HeaderProperty(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String asFieldName() {
            return this.fieldName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HeaderProperty) {
                HeaderProperty other = (HeaderProperty)obj;
                return Objects.equals(this.fieldName, other.fieldName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.fieldName);
        }

        public String toString() {
            return Objects.toString(this.fieldName);
        }
    }

    public static enum ReadProfile {
        Metadata(0),
        Header(1),
        Fast(2),
        Full(3);

        private final int priority;

        static ReadProfile combine(ReadProfile readProfile1, ReadProfile readProfile2) {
            if (readProfile1.priority > readProfile2.priority) {
                return readProfile1;
            }
            return readProfile2;
        }

        private ReadProfile(int priority) {
            this.priority = priority;
        }
    }

    public static enum MessageProperty implements Property
    {
        id("id", ReadProfile.Metadata),
        blobId("blobId", ReadProfile.Metadata),
        threadId("threadId", ReadProfile.Metadata),
        mailboxIds("mailboxIds", ReadProfile.Metadata),
        inReplyToMessageId("inReplyToMessageId", ReadProfile.Header),
        isUnread("isUnread", ReadProfile.Metadata),
        isFlagged("isFlagged", ReadProfile.Metadata),
        isAnswered("isAnswered", ReadProfile.Metadata),
        isDraft("isDraft", ReadProfile.Metadata),
        isForwarded("isForwarded", ReadProfile.Metadata),
        hasAttachment("hasAttachment", ReadProfile.Fast),
        headers("headers", ReadProfile.Header),
        from("from", ReadProfile.Header),
        to("to", ReadProfile.Header),
        cc("cc", ReadProfile.Header),
        bcc("bcc", ReadProfile.Header),
        replyTo("replyTo", ReadProfile.Header),
        subject("subject", ReadProfile.Header),
        date("date", ReadProfile.Header),
        size("size", ReadProfile.Metadata),
        preview("preview", ReadProfile.Fast),
        textBody("textBody", ReadProfile.Full),
        htmlBody("htmlBody", ReadProfile.Full),
        attachments("attachments", ReadProfile.Full),
        attachedMessages("attachedMessages", ReadProfile.Full),
        keywords("keywords", ReadProfile.Metadata),
        body("body", PropertyType.INPUTONLY, ReadProfile.Full);

        private final String property;
        private final PropertyType type;
        private final ReadProfile readProfile;
        private static final ImmutableMap<String, MessageProperty> LOOKUP_MAP;

        private MessageProperty(String property, ReadProfile readProfile) {
            this(property, PropertyType.INPUTOUTPUT, readProfile);
        }

        private MessageProperty(String property, PropertyType type, ReadProfile readProfile) {
            this.property = property;
            this.type = type;
            this.readProfile = readProfile;
        }

        @Override
        public String asFieldName() {
            return this.property;
        }

        public ReadProfile getReadProfile() {
            return this.readProfile;
        }

        public static Stream<MessageProperty> find(String property) {
            Preconditions.checkNotNull((Object)property);
            return Optional.ofNullable((MessageProperty)LOOKUP_MAP.get((Object)property)).stream();
        }

        public static ImmutableSet<MessageProperty> allOutputProperties() {
            return (ImmutableSet)Arrays.stream(MessageProperty.values()).filter(MessageProperty::outputProperty).collect(ImmutableSet.toImmutableSet());
        }

        private static boolean outputProperty(MessageProperty p) {
            switch (p.type) {
                case INPUTONLY: {
                    return false;
                }
                case INPUTOUTPUT: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }

        static {
            LOOKUP_MAP = (ImmutableMap)Arrays.stream(MessageProperty.values()).collect(ImmutableMap.toImmutableMap(v -> v.property, Function.identity()));
        }
    }

    private static enum PropertyType {
        INPUTONLY,
        INPUTOUTPUT;

    }
}

