/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadLookupDAO;
import org.apache.james.mailbox.exception.ThreadNotFoundException;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import org.apache.james.mailbox.store.mail.model.Subject;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraThreadIdGuessingAlgorithm
implements ThreadIdGuessingAlgorithm {
    private final MailboxManager mailboxManager;
    private final CassandraThreadDAO threadDAO;
    private final CassandraThreadLookupDAO threadLookupDAO;

    @Inject
    public CassandraThreadIdGuessingAlgorithm(MailboxManager mailboxManager, CassandraThreadDAO threadDAO, CassandraThreadLookupDAO threadLookupDAO) {
        this.mailboxManager = mailboxManager;
        this.threadDAO = threadDAO;
        this.threadLookupDAO = threadLookupDAO;
    }

    public Mono<ThreadId> guessThreadIdReactive(MessageId messageId, Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references, Optional<Subject> subject, MailboxSession session) {
        Set<MimeMessageId> mimeMessageIds = this.buildMimeMessageIdSet(mimeMessageId, inReplyTo, references);
        Optional<Subject> baseSubject = subject.map(value -> new Subject(SearchUtil.getBaseSubject((String)value.getValue())));
        return Flux.from(this.threadDAO.selectSome(session.getUser(), mimeMessageIds)).filter(pair -> ((Optional)pair.getLeft()).equals(baseSubject)).next().map(Pair::getRight).switchIfEmpty(Mono.just((Object)ThreadId.fromBaseMessageId((MessageId)messageId))).flatMap(threadId -> this.threadDAO.insertSome(session.getUser(), mimeMessageIds, messageId, (ThreadId)threadId, baseSubject).then(this.threadLookupDAO.insert(messageId, session.getUser(), mimeMessageIds)).then(Mono.just((Object)threadId)));
    }

    public Flux<MessageId> getMessageIdsInThread(ThreadId threadId, MailboxSession session) {
        SearchQuery searchQuery = SearchQuery.builder().andCriteria(new SearchQuery.Criterion[]{SearchQuery.threadId((ThreadId)threadId)}).sorts(new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, SearchQuery.Sort.Order.NATURAL)}).build();
        MultimailboxesSearchQuery expression = MultimailboxesSearchQuery.from((SearchQuery)searchQuery).build();
        return Flux.from((Publisher)this.mailboxManager.search(expression, session, Integer.MAX_VALUE)).switchIfEmpty((Publisher)Mono.error(() -> new ThreadNotFoundException(threadId)));
    }

    private Set<MimeMessageId> buildMimeMessageIdSet(Optional<MimeMessageId> mimeMessageId, Optional<MimeMessageId> inReplyTo, Optional<List<MimeMessageId>> references) {
        HashSet<MimeMessageId> mimeMessageIds = new HashSet<MimeMessageId>();
        mimeMessageId.ifPresent(mimeMessageIds::add);
        inReplyTo.ifPresent(mimeMessageIds::add);
        references.ifPresent(mimeMessageIds::addAll);
        return mimeMessageIds;
    }
}

