/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SimpleBodyCanonicalizer
extends FilterOutputStream {
    private static final boolean DEEP_DEBUG = false;
    private boolean lastWasCR;
    private int countCRLF;

    public SimpleBodyCanonicalizer(OutputStream arg0) {
        super(arg0);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.lastWasCR) {
            if (len > 0 && b[off] == 10) {
                ++this.countCRLF;
                this.lastWasCR = false;
                ++off;
                --len;
            } else {
                this.out.write(13);
                this.lastWasCR = false;
            }
        }
        int newCountCRLF = 0;
        boolean newLastWasCR = false;
        if (len >= 1 && b[off + len - 1] == 13) {
            newLastWasCR = true;
            --len;
        }
        while (len >= 2 && b[off + len - 1] == 10 && b[off + len - 2] == 13) {
            len -= 2;
            ++newCountCRLF;
        }
        if (len > 0) {
            this.dumpCRLF();
            this.out.write(b, off, len);
        }
        this.countCRLF += newCountCRLF;
        this.lastWasCR = newLastWasCR;
    }

    public void write(int b) throws IOException {
        if (this.lastWasCR && 10 == b) {
            this.lastWasCR = false;
            ++this.countCRLF;
        } else if (!this.lastWasCR && 13 == b) {
            this.lastWasCR = true;
        } else {
            this.dumpCRLF();
            if (13 == b) {
                this.lastWasCR = true;
            } else {
                this.out.write(b);
            }
        }
    }

    public void close() throws IOException {
        this.complete();
        super.close();
    }

    private void complete() throws IOException {
        if (this.lastWasCR) {
            this.lastWasCR = false;
        }
        this.countCRLF = 1;
        this.dumpCRLF();
    }

    private void dumpCRLF() throws IOException {
        if (this.lastWasCR) {
            this.out.write(13);
            this.lastWasCR = false;
        }
        while (this.countCRLF > 0) {
            this.out.write("\r\n".getBytes());
            --this.countCRLF;
        }
    }
}

