/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.api;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;

public enum HashMethod {
    SHA1{

        @Override
        public String asMessageDigestAlgorithm() {
            return "SHA-1";
        }
    }
    ,
    SHA256{

        @Override
        public String asMessageDigestAlgorithm() {
            return "SHA-256";
        }
    };


    public String asTagValue() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public abstract String asMessageDigestAlgorithm();

    public static Optional<HashMethod> of(String methodName) {
        return Arrays.stream(HashMethod.values()).filter(m -> m.name().toLowerCase(Locale.ROOT).equals(methodName.toLowerCase(Locale.ROOT))).findFirst();
    }
}

