/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchRequest;
import org.eclipse.jgit.transport.FilterSpec;

final class FetchV0Request
extends FetchRequest {
    FetchV0Request(@NonNull Set<ObjectId> wantIds, int depth, @NonNull Set<ObjectId> clientShallowCommits, @NonNull FilterSpec filterSpec, @NonNull Set<String> clientCapabilities, int deepenSince, @NonNull List<String> deepenNotRefs, @Nullable String agent, @Nullable String clientSID) {
        super(wantIds, depth, clientShallowCommits, filterSpec, clientCapabilities, deepenSince, deepenNotRefs, agent, clientSID);
    }

    static final class Builder {
        int depth;
        final List<String> deepenNots = new ArrayList<String>();
        int deepenSince;
        final Set<ObjectId> wantIds = new HashSet<ObjectId>();
        final Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
        FilterSpec filterSpec = FilterSpec.NO_FILTER;
        final Set<String> clientCaps = new HashSet<String>();
        String agent;
        String clientSID;

        Builder() {
        }

        Builder addWantId(ObjectId objectId) {
            this.wantIds.add(objectId);
            return this;
        }

        Builder setDepth(int d) {
            this.depth = d;
            return this;
        }

        int getDepth() {
            return this.depth;
        }

        boolean hasDeepenNots() {
            return !this.deepenNots.isEmpty();
        }

        Builder addDeepenNot(String deepenNot) {
            this.deepenNots.add(deepenNot);
            return this;
        }

        Builder setDeepenSince(int value) {
            this.deepenSince = value;
            return this;
        }

        int getDeepenSince() {
            return this.deepenSince;
        }

        Builder addClientShallowCommit(ObjectId shallowOid) {
            this.clientShallowCommits.add(shallowOid);
            return this;
        }

        Builder addClientCapabilities(Collection<String> clientCapabilities) {
            this.clientCaps.addAll(clientCapabilities);
            return this;
        }

        Builder setAgent(String clientAgent) {
            this.agent = clientAgent;
            return this;
        }

        Builder setClientSID(String clientSID) {
            this.clientSID = clientSID;
            return this;
        }

        Builder setFilterSpec(@NonNull FilterSpec filter2) {
            this.filterSpec = Objects.requireNonNull(filter2);
            return this;
        }

        FetchV0Request build() {
            return new FetchV0Request(this.wantIds, this.depth, this.clientShallowCommits, this.filterSpec, this.clientCaps, this.deepenSince, this.deepenNots, this.agent, this.clientSID);
        }
    }
}

