/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.reactive;

import java.util.function.Function;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.transaction.reactive.TransactionContext;
import org.springframework.transaction.reactive.TransactionContextManager;
import reactor.core.publisher.Mono;

public class TransactionalEventPublisher {
    private final ApplicationEventPublisher eventPublisher;

    public TransactionalEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Mono<Void> publishEvent(Function<TransactionContext, ApplicationEvent> eventCreationFunction) {
        return TransactionContextManager.currentContext().map(eventCreationFunction).doOnSuccess(this.eventPublisher::publishEvent).then();
    }

    public Mono<Void> publishEvent(Object payload) {
        if (payload instanceof ApplicationEvent) {
            return Mono.error(new IllegalArgumentException("Cannot publish ApplicationEvent with transactional source - publish payload object or use publishEvent(Function<Object, ApplicationEvent>"));
        }
        return this.publishEvent((TransactionContext source) -> new PayloadApplicationEvent<Object>(source, payload));
    }
}

