/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.studio.ldapservers.LdapServersPluginConstants;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapter;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LdapServerAdapterExtensionsManager {
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String VERSION_ATTR = "version";
    public static final String VENDOR_ATTR = "vendor";
    public static final String CLASS_ATTR = "class";
    public static final String DESCRIPTION_ATTR = "description";
    public static final String ICON_ATTR = "icon";
    public static final String CONFIGURATION_PAGE_ATTR = "configurationPage";
    public static final String OPEN_CONFIGURATION_ACTION_ENABLED_ATTR = "openConfigurationActionEnabled";
    private static LdapServerAdapterExtensionsManager instance;
    private List<LdapServerAdapterExtension> ldapServerAdapterExtensionsList;
    private Map<String, LdapServerAdapterExtension> ldapServerAdapterExtensionsByIdMap;

    private LdapServerAdapterExtensionsManager() {
    }

    public void loadLdapServerAdapterExtensions() {
        IConfigurationElement[] members;
        this.ldapServerAdapterExtensionsList = new ArrayList<LdapServerAdapterExtension>();
        this.ldapServerAdapterExtensionsByIdMap = new HashMap<String, LdapServerAdapterExtension>();
        IConfigurationElement[] iConfigurationElementArray = members = Platform.getExtensionRegistry().getExtensionPoint(LdapServersPluginConstants.LDAP_SERVER_ADAPTERS_EXTENSION_POINT).getConfigurationElements();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement member = iConfigurationElementArray[n2];
            LdapServerAdapterExtension ldapServerAdapterExtension = new LdapServerAdapterExtension();
            String extendingPluginId = member.getDeclaringExtension().getNamespaceIdentifier();
            ldapServerAdapterExtension.setExtensionPointConfiguration(member);
            ldapServerAdapterExtension.setId(member.getAttribute(ID_ATTR));
            ldapServerAdapterExtension.setName(member.getAttribute(NAME_ATTR));
            ldapServerAdapterExtension.setVersion(member.getAttribute(VERSION_ATTR));
            ldapServerAdapterExtension.setVendor(member.getAttribute(VENDOR_ATTR));
            ldapServerAdapterExtension.setClassName(member.getAttribute(CLASS_ATTR));
            try {
                ldapServerAdapterExtension.setInstance((LdapServerAdapter)member.createExecutableExtension(CLASS_ATTR));
            }
            catch (CoreException coreException) {}
            ldapServerAdapterExtension.setDescription(member.getAttribute(DESCRIPTION_ATTR));
            String iconPath = member.getAttribute(ICON_ATTR);
            if (iconPath != null) {
                ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconPath);
                if (icon == null) {
                    icon = ImageDescriptor.getMissingImageDescriptor();
                }
                ldapServerAdapterExtension.setIcon(icon);
            }
            ldapServerAdapterExtension.setConfigurationPageClassName(member.getAttribute(CONFIGURATION_PAGE_ATTR));
            String openConfigurationActionEnabled = member.getAttribute(OPEN_CONFIGURATION_ACTION_ENABLED_ATTR);
            if (openConfigurationActionEnabled != null) {
                ldapServerAdapterExtension.setOpenConfigurationActionEnabled(Boolean.parseBoolean(openConfigurationActionEnabled));
            } else {
                ldapServerAdapterExtension.setOpenConfigurationActionEnabled(true);
            }
            this.ldapServerAdapterExtensionsList.add(ldapServerAdapterExtension);
            this.ldapServerAdapterExtensionsByIdMap.put(ldapServerAdapterExtension.getId(), ldapServerAdapterExtension);
            ++n2;
        }
    }

    public static LdapServerAdapterExtensionsManager getDefault() {
        if (instance == null) {
            instance = new LdapServerAdapterExtensionsManager();
        }
        return instance;
    }

    public List<LdapServerAdapterExtension> getLdapServerAdapterExtensions() {
        return this.ldapServerAdapterExtensionsList;
    }

    public LdapServerAdapterExtension getLdapServerAdapterExtensionById(String id) {
        return this.ldapServerAdapterExtensionsByIdMap.get(id);
    }
}

