/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.apache.deltaspike.proxy.impl.AsmDeltaSpikeProxyClassGenerator;

class ClassDefiner {
    private static final Method CLASS_LOADER_DEFINE_CLASS;
    private static final Method GET_MODULE;
    private static final Method CAN_READ;
    private static final Method ADD_READS;
    private static final Method PRIVATE_LOOKUP_IN;
    private static final Method DEFINE_CLASS;

    private ClassDefiner() {
    }

    static Class<?> defineClass(ClassLoader loader, String className, byte[] b, Class<?> originalClass, ProtectionDomain protectionDomain) {
        if (CLASS_LOADER_DEFINE_CLASS == null) {
            return ClassDefiner.defineClassMethodHandles(loader, className, b, originalClass, protectionDomain);
        }
        return ClassDefiner.defineClassClassLoader(loader, className, b, originalClass, protectionDomain);
    }

    static Class<?> defineClassClassLoader(ClassLoader loader, String className, byte[] b, Class<?> originalClass, ProtectionDomain protectionDomain) {
        try {
            return (Class)CLASS_LOADER_DEFINE_CLASS.invoke((Object)loader, className, b, 0, b.length, protectionDomain);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    static Class<?> defineClassMethodHandles(ClassLoader loader, String className, byte[] b, Class<?> originalClass, ProtectionDomain protectionDomain) {
        try {
            Object thisModule = GET_MODULE.invoke(AsmDeltaSpikeProxyClassGenerator.class, new Object[0]);
            Object lookupClassModule = GET_MODULE.invoke(originalClass, new Object[0]);
            if (!((Boolean)CAN_READ.invoke(thisModule, lookupClassModule)).booleanValue()) {
                ADD_READS.invoke(thisModule, lookupClassModule);
            }
            Object lookup = PRIVATE_LOOKUP_IN.invoke(null, originalClass, MethodHandles.lookup());
            return (Class)DEFINE_CLASS.invoke(lookup, new Object[]{b});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method classLoaderDefineClass = null;
        try {
            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            method.setAccessible(true);
            classLoaderDefineClass = method;
        }
        catch (Exception method) {
            // empty catch block
        }
        CLASS_LOADER_DEFINE_CLASS = classLoaderDefineClass;
        Method getModule = null;
        Method canRead = null;
        Method addReads = null;
        Method privateLookupIn = null;
        Method defineClass = null;
        try {
            getModule = Class.class.getMethod("getModule", new Class[0]);
            Class<?> moduleClass = getModule.getReturnType();
            canRead = moduleClass.getMethod("canRead", moduleClass);
            addReads = moduleClass.getMethod("addReads", moduleClass);
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            defineClass = MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_MODULE = getModule;
        CAN_READ = canRead;
        ADD_READS = addReads;
        PRIVATE_LOOKUP_IN = privateLookupIn;
        DEFINE_CLASS = defineClass;
    }
}

