/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.exclude.extension;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.spi.alternative.AlternativeBeanClassProvider;

public class LabelAwareGlobalAlternativeBeanClassProvider
implements AlternativeBeanClassProvider {
    private static final String GLOBAL_ALTERNATIVES = "globalAlternatives.";
    private static final String LABELED_ALTERNATIVES = "labeledAlternatives";
    private static final String ACTIVE_ALTERNATIVE_LABEL_KEY = "activeAlternativeLabel";
    private static final Logger LOG = Logger.getLogger(LabelAwareGlobalAlternativeBeanClassProvider.class.getName());

    public Map<String, String> getAlternativeMapping() {
        HashMap<String, String> result = new HashMap<String, String>();
        String alternativeLabel = ConfigResolver.getPropertyValue((String)ACTIVE_ALTERNATIVE_LABEL_KEY);
        String activeQualifierLabel = null;
        if (alternativeLabel != null) {
            activeQualifierLabel = "labeledAlternatives[" + alternativeLabel + "].";
        }
        Map allProperties = ConfigResolver.getAllProperties();
        for (Map.Entry property : allProperties.entrySet()) {
            String implementation;
            String interfaceName;
            if (activeQualifierLabel != null && ((String)property.getKey()).startsWith(activeQualifierLabel)) {
                interfaceName = ((String)property.getKey()).substring(activeQualifierLabel.length());
                implementation = (String)property.getValue();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Enabling labeled alternative for interface " + interfaceName + ": " + implementation);
                }
                result.put(interfaceName, implementation);
                continue;
            }
            if (!((String)property.getKey()).startsWith(GLOBAL_ALTERNATIVES)) continue;
            interfaceName = ((String)property.getKey()).substring(GLOBAL_ALTERNATIVES.length());
            implementation = (String)property.getValue();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Enabling global alternative for interface " + interfaceName + ": " + implementation);
            }
            if (result.containsKey(interfaceName)) continue;
            result.put(interfaceName, implementation);
        }
        return result;
    }
}

