/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.injection;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.jsf.impl.injection.AbstractBeanStorage;
import org.apache.deltaspike.jsf.impl.injection.DependentBeanEntry;
import org.apache.deltaspike.jsf.impl.injection.RequestDependentBeanStorage;

@Typed
public abstract class ManagedArtifactResolver {
    public static final String JAVAX_FACES_CONVERT_PACKAGE_NAME = "javax.faces.convert";
    public static final String JAVAX_FACES_VALIDATOR_PACKAGE_NAME = "javax.faces.validator";

    private ManagedArtifactResolver() {
    }

    public static Converter resolveManagedConverter(Class<? extends Converter> converterClass) {
        if (JAVAX_FACES_CONVERT_PACKAGE_NAME.equals(converterClass.getPackage().getName())) {
            return null;
        }
        return ManagedArtifactResolver.getContextualReference(BeanManagerProvider.getInstance().getBeanManager(), converterClass);
    }

    public static Validator resolveManagedValidator(Class<? extends Validator> validatorClass) {
        if (JAVAX_FACES_VALIDATOR_PACKAGE_NAME.equals(validatorClass.getPackage().getName())) {
            return null;
        }
        return ManagedArtifactResolver.getContextualReference(BeanManagerProvider.getInstance().getBeanManager(), validatorClass);
    }

    private static <T> T getContextualReference(BeanManager beanManager, Class<T> type) {
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(beans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Object result = beanManager.getReference(bean, type, creationalContext);
        if (bean.getScope().equals(Dependent.class)) {
            AbstractBeanStorage beanStorage = (AbstractBeanStorage)BeanProvider.getContextualReference(RequestDependentBeanStorage.class, (Annotation[])new Annotation[0]);
            beanStorage.add(new DependentBeanEntry<Object>(result, bean, creationalContext));
        }
        return (T)result;
    }
}

