/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view.navigation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.jsf.api.config.view.View;
import org.apache.deltaspike.jsf.impl.util.JsfUtils;
import org.apache.deltaspike.jsf.impl.util.RequestParameter;

public class NavigationCaseMapWrapper
implements Map<String, Set<NavigationCase>> {
    private static final Logger LOG = Logger.getLogger(NavigationCaseMapWrapper.class.getName());
    private Map<String, Set<NavigationCase>> wrappedNavigationCaseMap;
    private final NavigationHandler wrapped;
    private final Map<String, Set<NavigationCase>> viewConfigBasedNavigationCaseCache;

    public NavigationCaseMapWrapper(Map<String, Set<NavigationCase>> navigationCases, NavigationHandler wrapped) {
        this.wrappedNavigationCaseMap = navigationCases;
        this.wrapped = wrapped;
        this.viewConfigBasedNavigationCaseCache = this.createViewConfigBasedNavigationCases(false);
    }

    private Map<String, Set<NavigationCase>> createViewConfigBasedNavigationCases(boolean allowParameters) {
        HashMap result;
        if (this.wrapped instanceof ConfigurableNavigationHandler) {
            result = new DelegatingMap((ConfigurableNavigationHandler)this.wrapped);
        } else {
            LOG.warning("the wrapped navigation-handler doesn't extend " + ConfigurableNavigationHandler.class.getName() + ". therefore std. navigation-rules might not work correctly with mojarra");
            result = new HashMap();
        }
        List viewConfigDescriptors = ((ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0])).getViewConfigDescriptors();
        if (!viewConfigDescriptors.isEmpty()) {
            HashSet<NavigationCase> navigationCase = new HashSet<NavigationCase>();
            Map<String, List<String>> parameters = null;
            if (allowParameters) {
                parameters = this.resolveParameters();
            }
            for (ViewConfigDescriptor entry : viewConfigDescriptors) {
                View viewMetaData = (View)entry.getMetaData(View.class).iterator().next();
                boolean includeParameters = View.ViewParameterMode.INCLUDE.equals((Object)viewMetaData.viewParams());
                navigationCase.add(new NavigationCase("*", null, null, null, entry.getViewId(), includeParameters ? parameters : null, View.NavigationMode.REDIRECT.equals((Object)viewMetaData.navigation()), includeParameters));
                result.put(entry.getViewId(), navigationCase);
            }
        }
        return result;
    }

    private Map<String, List<String>> resolveParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (RequestParameter parameter : JsfUtils.getViewConfigPageParameters()) {
            parameters.put(parameter.getKey(), parameter.getValueList());
        }
        return parameters;
    }

    @Override
    public int size() {
        return this.wrappedNavigationCaseMap.size() + this.viewConfigBasedNavigationCaseCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedNavigationCaseMap.isEmpty() && this.viewConfigBasedNavigationCaseCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedNavigationCaseMap.containsKey(key) || this.viewConfigBasedNavigationCaseCache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedNavigationCaseMap.containsValue(value) || this.viewConfigBasedNavigationCaseCache.containsValue(value);
    }

    @Override
    public Set<NavigationCase> get(Object key) {
        Set<NavigationCase> result = this.wrappedNavigationCaseMap.get(key);
        if (result == null) {
            return this.createViewConfigBasedNavigationCases(true).get(key);
        }
        return result;
    }

    @Override
    public Set<NavigationCase> put(String key, Set<NavigationCase> value) {
        return this.wrappedNavigationCaseMap.put(key, value);
    }

    @Override
    public Set<NavigationCase> remove(Object key) {
        return this.wrappedNavigationCaseMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Set<NavigationCase>> m) {
        this.wrappedNavigationCaseMap.putAll(m);
    }

    @Override
    public void clear() {
        this.wrappedNavigationCaseMap.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.wrappedNavigationCaseMap.keySet());
        result.addAll(this.viewConfigBasedNavigationCaseCache.keySet());
        return result;
    }

    @Override
    public Collection<Set<NavigationCase>> values() {
        HashSet<Set<NavigationCase>> result = new HashSet<Set<NavigationCase>>();
        result.addAll(this.wrappedNavigationCaseMap.values());
        result.addAll(this.createViewConfigBasedNavigationCases(true).values());
        return result;
    }

    @Override
    public Set<Map.Entry<String, Set<NavigationCase>>> entrySet() {
        HashSet<Map.Entry<String, Set<NavigationCase>>> result = new HashSet<Map.Entry<String, Set<NavigationCase>>>();
        result.addAll(this.wrappedNavigationCaseMap.entrySet());
        result.addAll(this.createViewConfigBasedNavigationCases(true).entrySet());
        return result;
    }

    private class DelegatingSet
    extends HashSet<NavigationCase> {
        private static final long serialVersionUID = -7040572530963900394L;
        private final ConfigurableNavigationHandler wrapped;
        private String navigationCaseKey;

        private DelegatingSet(Collection<? extends NavigationCase> c, ConfigurableNavigationHandler wrapped, String navigationCaseKey) {
            super(c);
            this.wrapped = wrapped;
            this.navigationCaseKey = navigationCaseKey;
        }

        @Override
        public boolean add(NavigationCase navigationCase) {
            HashSet<NavigationCase> navigationCases = (HashSet<NavigationCase>)this.wrapped.getNavigationCases().get(this.navigationCaseKey);
            if (navigationCases == null) {
                navigationCases = new HashSet<NavigationCase>();
                this.wrapped.getNavigationCases().put(this.navigationCaseKey, navigationCases);
            }
            return navigationCases.add(navigationCase);
        }
    }

    private class DelegatingMap
    extends HashMap<String, Set<NavigationCase>> {
        private static final long serialVersionUID = -955468874397821639L;
        private final ConfigurableNavigationHandler wrapped;

        private DelegatingMap(ConfigurableNavigationHandler wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Set<NavigationCase> put(String key, Set<NavigationCase> value) {
            if (value == null) {
                return null;
            }
            HashSet<NavigationCase> result = new HashSet<NavigationCase>();
            for (NavigationCase navigationCase : value) {
                if (navigationCase.getFromOutcome() == null && navigationCase.getFromAction() == null) continue;
                result.add(navigationCase);
            }
            return this.wrapped.getNavigationCases().put(key, result);
        }

        @Override
        public Set<NavigationCase> get(Object key) {
            HashSet<NavigationCase> navigationCases = (HashSet<NavigationCase>)super.get(key);
            if (navigationCases == null) {
                navigationCases = new HashSet<NavigationCase>();
                this.put((String)key, (Set<NavigationCase>)navigationCases);
            }
            return new DelegatingSet(navigationCases, this.wrapped, (String)key);
        }
    }
}

