/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.tx;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.handler.QueryRunner;
import org.apache.deltaspike.data.impl.tx.InvocationContextWrapper;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;
import org.apache.deltaspike.jpa.spi.transaction.TransactionStrategy;

@ApplicationScoped
public class TransactionalQueryRunner
implements QueryRunner {
    @Inject
    private TransactionStrategy strategy;
    @Inject
    private ActiveEntityManagerHolder activeEntityManagerHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeQuery(QueryBuilder builder, CdiQueryInvocationContext context) throws Throwable {
        if (context.getRepositoryMethodMetadata().isRequiresTransaction()) {
            try {
                this.activeEntityManagerHolder.set(context.getEntityManager());
                Object object = this.executeTransactional(builder, context);
                return object;
            }
            finally {
                this.activeEntityManagerHolder.dispose();
            }
        }
        return this.executeNonTransactional(builder, context);
    }

    protected Object executeNonTransactional(QueryBuilder builder, CdiQueryInvocationContext context) {
        return builder.executeQuery(context);
    }

    protected Object executeTransactional(final QueryBuilder builder, final CdiQueryInvocationContext context) throws Exception {
        return this.strategy.execute((InvocationContext)new InvocationContextWrapper(context){

            public Object proceed() throws Exception {
                return builder.executeQuery(context);
            }
        });
    }
}

