/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.base.CoreBaseConfig;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.spi.activation.ClassDeactivator;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.core.util.ServiceUtils;

@Typed
public abstract class ClassDeactivationUtils {
    private static final Logger LOG = Logger.getLogger(ClassDeactivationUtils.class.getName());
    private static Map<ClassLoader, List<ClassDeactivator>> classDeactivatorMap = new ConcurrentHashMap<ClassLoader, List<ClassDeactivator>>();
    private static Map<Class<? extends Deactivatable>, Boolean> activationStatusCache = new ConcurrentHashMap<Class<? extends Deactivatable>, Boolean>();
    private static ProjectStage previouslyDetectedProjectStage;

    private ClassDeactivationUtils() {
    }

    public static void clearCache() {
        classDeactivatorMap.clear();
    }

    public static boolean isActivated(Class<? extends Deactivatable> targetClass) {
        ClassDeactivationUtils.performProjectStageDependentCleanup();
        Map<Class<? extends Deactivatable>, Boolean> activeCache = activationStatusCache;
        Boolean activatedClassCacheEntry = activeCache.get(targetClass);
        if (activatedClassCacheEntry == null) {
            ClassDeactivationUtils.initDeactivatableCacheFor(targetClass, activeCache);
            activatedClassCacheEntry = activeCache.get(targetClass);
        }
        return activatedClassCacheEntry;
    }

    private static void performProjectStageDependentCleanup() {
        ProjectStage currentProjectStage = ProjectStageProducer.getInstance().getProjectStage();
        if (previouslyDetectedProjectStage != currentProjectStage) {
            previouslyDetectedProjectStage = currentProjectStage;
            activationStatusCache = new ConcurrentHashMap<Class<? extends Deactivatable>, Boolean>();
            classDeactivatorMap.clear();
        } else if (currentProjectStage == ProjectStage.UnitTest || currentProjectStage == ProjectStage.Development) {
            activationStatusCache = new ConcurrentHashMap<Class<? extends Deactivatable>, Boolean>();
        }
    }

    private static synchronized void initDeactivatableCacheFor(Class<? extends Deactivatable> targetClass, Map<Class<? extends Deactivatable>, Boolean> activeCache) {
        Boolean activatedClassCacheEntry = activeCache.get(targetClass);
        if (activatedClassCacheEntry != null) {
            return;
        }
        List<ClassDeactivator> classDeactivators = ClassDeactivationUtils.getClassDeactivators();
        Boolean isActivated = Boolean.TRUE;
        Class<?> deactivatedBy = null;
        LOG.fine("start evaluation if " + targetClass.getName() + " is de-/activated");
        for (ClassDeactivator classDeactivator : classDeactivators) {
            Boolean isLocallyActivated = classDeactivator.isActivated(targetClass);
            if (isLocallyActivated == null) continue;
            isActivated = isLocallyActivated;
            if (!isActivated.booleanValue()) {
                deactivatedBy = classDeactivator.getClass();
                LOG.fine("Deactivating class " + targetClass);
                continue;
            }
            if (deactivatedBy == null) continue;
            LOG.fine("Reactivation of: " + targetClass.getName() + " by " + classDeactivator.getClass().getName() + " - original deactivated by: " + deactivatedBy.getName() + ".\nIf that isn't the intended behaviour, you have to use a higher ordinal for " + deactivatedBy.getName());
        }
        ClassDeactivationUtils.cacheResult(targetClass, isActivated, activeCache);
    }

    private static void cacheResult(Class<? extends Deactivatable> targetClass, Boolean activated, Map<Class<? extends Deactivatable>, Boolean> activeCache) {
        activeCache.put(targetClass, activated);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("class: " + targetClass.getName() + " activated=" + activated);
        }
    }

    private static List<ClassDeactivator> getClassDeactivators() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        List<ClassDeactivator> classDeactivators = classDeactivatorMap.get(classLoader);
        if (classDeactivators == null) {
            return ClassDeactivationUtils.initConfiguredClassDeactivators(classLoader);
        }
        return classDeactivators;
    }

    private static List<ClassDeactivator> initConfiguredClassDeactivators(ClassLoader classLoader) {
        if (!ServiceUtils.loadServiceImplementations(ClassDeactivator.class).isEmpty()) {
            CoreBaseConfig.Validation.ViolationMode violationMode = CoreBaseConfig.Validation.VIOLATION_MODE;
            String message = "It isn't supported to configure " + ClassDeactivator.class.getName() + " via the std. service-loader config. Please remove all META-INF/services/" + ClassDeactivator.class.getName() + " files. Please configure it via the DeltaSpike-Config (e.g. META-INF/apache-deltaspike.properties).";
            if (violationMode == CoreBaseConfig.Validation.ViolationMode.FAIL) {
                throw new IllegalStateException(message);
            }
            if (violationMode == CoreBaseConfig.Validation.ViolationMode.WARN) {
                LOG.warning(message);
            }
        }
        List<String> classDeactivatorClassNames = ConfigResolver.getAllPropertyValues(ClassDeactivator.class.getName());
        ArrayList<ClassDeactivator> classDeactivators = new ArrayList<ClassDeactivator>();
        for (String classDeactivatorClassName : classDeactivatorClassNames) {
            LOG.fine("processing ClassDeactivator: " + classDeactivatorClassName);
            try {
                ClassDeactivator currentClassDeactivator = (ClassDeactivator)ClassUtils.instantiateClassForName(classDeactivatorClassName);
                classDeactivators.add(currentClassDeactivator);
            }
            catch (Exception e) {
                LOG.warning(classDeactivatorClassName + " can't be instantiated");
                throw new IllegalStateException(e);
            }
        }
        classDeactivatorMap.put(classLoader, classDeactivators);
        return classDeactivators;
    }
}

