/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om.mapper;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;

public class CompositeMapper
implements RecordMapper<List<Object>> {
    private static final long serialVersionUID = 1L;
    private final List<MapperWithOffset> mapperList = new ArrayList<MapperWithOffset>();

    public void addMapper(RecordMapper<?> mapper, int offset) {
        this.mapperList.add(new MapperWithOffset(mapper, offset));
    }

    @Override
    public List<Object> processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        ArrayList<Object> result = new ArrayList<Object>(this.mapperList.size());
        for (MapperWithOffset mapperWithOffset : this.mapperList) {
            int totalOffset = offset + mapperWithOffset.getOffset();
            RecordMapper<?> mapper = mapperWithOffset.getMapper();
            result.add(mapper.processRow(resultSet, totalOffset, criteria));
        }
        return result;
    }

    private static class MapperWithOffset
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final RecordMapper<?> mapper;
        private final int offset;

        public MapperWithOffset(RecordMapper<?> mapper, int offset) {
            this.mapper = mapper;
            this.offset = offset;
        }

        public RecordMapper<?> getMapper() {
            return this.mapper;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

