/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class BoundaryGenerator
extends Generator {
    static final int UNINTERESTING = 4;
    Generator g;

    BoundaryGenerator(RevWalk w, Generator s) {
        this.g = new InitialGenerator(w, s);
    }

    int outputType() {
        return this.g.outputType() | 0x10;
    }

    void shareFreeList(BlockRevQueue q) {
        this.g.shareFreeList(q);
    }

    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.g.next();
    }

    private class InitialGenerator
    extends Generator {
        private static final int PARSED = 1;
        private static final int DUPLICATE = 16;
        private final RevWalk walk;
        private final FIFORevQueue held;
        private final Generator source;

        InitialGenerator(RevWalk w, Generator s) {
            this.walk = w;
            this.held = new FIFORevQueue();
            this.source = s;
            this.source.shareFreeList(this.held);
        }

        int outputType() {
            return this.source.outputType();
        }

        void shareFreeList(BlockRevQueue q) {
            q.shareFreeList(this.held);
        }

        RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevCommit c = this.source.next();
            if (c != null) {
                for (RevCommit p : c.parents) {
                    if ((p.flags & 4) == 0) continue;
                    this.held.add(p);
                }
                return c;
            }
            FIFORevQueue boundary = new FIFORevQueue();
            boundary.shareFreeList(this.held);
            while ((c = this.held.next()) != null) {
                if ((c.flags & 0x10) != 0) continue;
                if ((c.flags & 1) == 0) {
                    c.parseHeaders(this.walk);
                }
                c.flags |= 0x10;
                boundary.add(c);
            }
            boundary.removeFlag(16);
            BoundaryGenerator.this.g = boundary;
            return boundary.next();
        }
    }
}

