/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import org.apache.datasketches.pig.tuple.ArrayOfDoublesSketchToEstimates;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToEstimatesTest {
    @Test
    public void nullInput() throws Exception {
        ArrayOfDoublesSketchToEstimates func = new ArrayOfDoublesSketchToEstimates();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptyInput() throws Exception {
        ArrayOfDoublesSketchToEstimates func = new ArrayOfDoublesSketchToEstimates();
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptySketch() throws Exception {
        ArrayOfDoublesSketchToEstimates func = new ArrayOfDoublesSketchToEstimates();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)2);
        Assert.assertEquals((Object)resultTuple.get(0), (Object)0.0);
        Assert.assertEquals((Object)resultTuple.get(1), (Object)0.0);
    }

    @Test
    public void normalCase() throws Exception {
        int i;
        ArrayOfDoublesSketchToEstimates func = new ArrayOfDoublesSketchToEstimates();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        int iterations = 100000;
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, new double[]{1.0});
        }
        for (i = 0; i < iterations; ++i) {
            sketch.update((long)i, new double[]{1.0});
        }
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)2);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)iterations, (double)((double)iterations * 0.03));
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)(2 * iterations), (double)((double)(2 * iterations) * 0.03));
    }
}

