/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.Positional;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.internal.WritableBufferImpl;

public interface Buffer
extends Positional,
Resource {
    public static Buffer wrap(ByteBuffer byteBuffer) {
        return Buffer.wrap(byteBuffer, ByteOrder.nativeOrder());
    }

    public static Buffer wrap(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        return WritableBufferImpl.wrapByteBuffer(byteBuffer, true, byteOrder, null);
    }

    default public Buffer duplicate() {
        return this.duplicate(this.getTypeByteOrder());
    }

    public Buffer duplicate(ByteOrder var1);

    default public Buffer region() {
        return this.region(this.getPosition(), this.getEnd() - this.getPosition(), this.getTypeByteOrder());
    }

    public Buffer region(long var1, long var3, ByteOrder var5);

    default public Memory asMemory() {
        return this.asMemory(this.getTypeByteOrder());
    }

    public Memory asMemory(ByteOrder var1);

    public boolean getBoolean();

    public boolean getBoolean(long var1);

    public byte getByte();

    public byte getByte(long var1);

    public void getByteArray(byte[] var1, int var2, int var3);

    public char getChar();

    public char getChar(long var1);

    public void getCharArray(char[] var1, int var2, int var3);

    public double getDouble();

    public double getDouble(long var1);

    public void getDoubleArray(double[] var1, int var2, int var3);

    public float getFloat();

    public float getFloat(long var1);

    public void getFloatArray(float[] var1, int var2, int var3);

    public int getInt();

    public int getInt(long var1);

    public void getIntArray(int[] var1, int var2, int var3);

    public long getLong();

    public long getLong(long var1);

    public void getLongArray(long[] var1, int var2, int var3);

    public short getShort();

    public short getShort(long var1);

    public void getShortArray(short[] var1, int var2, int var3);
}

