/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.AllocateDirectWritableMap;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.UtilTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ThreadTest {
    File file;
    Memory mem;
    WritableMemory wmem;
    Thread altThread;
    Runnable tryMapClose = () -> {
        try {
            this.mem.close();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    };
    Runnable tryDirectClose = () -> {
        try {
            this.wmem.close();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    };

    @BeforeClass
    public void prepareFileAndMemory() throws IOException {
        UtilTest.setGettysburgAddressFileToReadOnly();
        this.file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Assert.assertTrue((boolean)AllocateDirectWritableMap.isFileReadOnly((File)this.file));
    }

    void initMap() throws IOException {
        this.mem = Memory.map((File)this.file);
        Assert.assertTrue((boolean)this.mem.isAlive());
    }

    void initDirectMem() {
        this.wmem = WritableMemory.allocateDirect((long)1024L);
        Assert.assertTrue((boolean)this.wmem.isAlive());
    }

    @Test
    public void runTests() throws IOException {
        this.initMap();
        this.altThread = new Thread(this.tryMapClose, "altThread");
        this.altThread.start();
        this.mem.close();
        this.initDirectMem();
        this.altThread = new Thread(this.tryDirectClose, "altThread");
        this.altThread.start();
        this.wmem.close();
    }
}

