/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

final class ObjectInspectorValidator {
    ObjectInspectorValidator() {
    }

    static void validateCategoryPrimitive(ObjectInspector inspector, int index) throws SemanticException {
        if (inspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(index, "Primitive argument expected, but " + inspector.getCategory().name() + " was recieved");
        }
    }

    static void validateGivenPrimitiveCategory(ObjectInspector inspector, int index, PrimitiveObjectInspector.PrimitiveCategory category) throws SemanticException {
        ObjectInspectorValidator.validateCategoryPrimitive(inspector, index);
        PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)inspector;
        if (primitiveInspector.getPrimitiveCategory() != category) {
            throw new UDFArgumentTypeException(index, category.name() + " value expected as the argument " + (index + 1) + " but " + primitiveInspector.getPrimitiveCategory().name() + " was received");
        }
    }
}

