/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow;

import jakarta.annotation.Resource;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.transport.http_undertow.ThreadingParameters;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngine;

@NoJSR250Annotations(unlessNull={"bus"})
public class UndertowHTTPServerEngineFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(UndertowHTTPServerEngineFactory.class);
    private static final int FALLBACK_THREADING_PARAMS_KEY = 0;
    private static ConcurrentHashMap<Integer, UndertowHTTPServerEngine> portMap = new ConcurrentHashMap();
    private BusLifeCycleManager lifeCycleManager;
    private Map<String, ThreadingParameters> threadingParametersMap = new TreeMap<String, ThreadingParameters>();
    private ThreadingParameters fallbackThreadingParameters;
    private Map<String, TLSServerParameters> tlsParametersMap = new TreeMap<String, TLSServerParameters>();
    private Bus bus;

    public UndertowHTTPServerEngineFactory() {
    }

    public UndertowHTTPServerEngineFactory(Bus b) {
        this.setBus(b);
    }

    public UndertowHTTPServerEngineFactory(Bus b, Map<String, TLSServerParameters> tls, Map<String, ThreadingParameters> threading) {
        this.tlsParametersMap.putAll(tls);
        this.threadingParametersMap.putAll(threading);
        this.setBus(b);
    }

    private static UndertowHTTPServerEngine getOrCreate(UndertowHTTPServerEngineFactory factory, String host, int port, TLSServerParameters tlsParams) throws IOException, GeneralSecurityException {
        UndertowHTTPServerEngine ref = portMap.get(port);
        if (ref == null) {
            ref = new UndertowHTTPServerEngine(host, port);
            if (tlsParams != null) {
                ref.setTlsServerParameters(tlsParams);
            }
            UndertowHTTPServerEngine tmpRef = portMap.putIfAbsent(port, ref);
            ref.finalizeConfig();
            if (tmpRef != null) {
                ref = tmpRef;
            }
        }
        return ref;
    }

    @Resource(name="cxf")
    public final void setBus(Bus bus) {
        this.bus = bus;
        if (bus != null) {
            bus.setExtension((Object)this, UndertowHTTPServerEngineFactory.class);
            this.lifeCycleManager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
            if (null != this.lifeCycleManager) {
                this.lifeCycleManager.registerLifeCycleListener((BusLifeCycleListener)new UndertowBusLifeCycleListener());
            }
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setTlsServerParametersMap(Map<String, TLSServerParameters> tlsParamsMap) {
        this.tlsParametersMap = tlsParamsMap;
    }

    public Map<String, TLSServerParameters> getTlsServerParametersMap() {
        return this.tlsParametersMap;
    }

    public void setEnginesList(List<UndertowHTTPServerEngine> enginesList) {
        for (UndertowHTTPServerEngine engine : enginesList) {
            if (engine.getPort() == 0) {
                this.fallbackThreadingParameters = engine.getThreadingParameters();
            }
            portMap.putIfAbsent(engine.getPort(), engine);
        }
    }

    public void setThreadingParametersMap(Map<String, ThreadingParameters> threadingParamsMap) {
        this.threadingParametersMap = threadingParamsMap;
    }

    public Map<String, ThreadingParameters> getThreadingParametersMap() {
        return this.threadingParametersMap;
    }

    public void setTLSServerParametersForPort(String host, int port, TLSServerParameters tlsParams) throws GeneralSecurityException, IOException {
        if (tlsParams == null) {
            throw new IllegalArgumentException("tlsParams cannot be null");
        }
        UndertowHTTPServerEngine ref = this.retrieveUndertowHTTPServerEngine(port);
        if (null == ref) {
            UndertowHTTPServerEngineFactory.getOrCreate(this, host, port, tlsParams);
        } else {
            ref.setTlsServerParameters(tlsParams);
        }
    }

    public void setTLSServerParametersForPort(int port, TLSServerParameters tlsParams) throws GeneralSecurityException, IOException {
        this.setTLSServerParametersForPort(null, port, tlsParams);
    }

    public synchronized UndertowHTTPServerEngine retrieveUndertowHTTPServerEngine(int port) {
        return portMap.get(port);
    }

    public synchronized UndertowHTTPServerEngine createUndertowHTTPServerEngine(String host, int port, String protocol) throws GeneralSecurityException, IOException {
        LOG.fine("Creating Undertow HTTP Server Engine for port " + port + ".");
        UndertowHTTPServerEngine ref = UndertowHTTPServerEngineFactory.getOrCreate(this, host, port, null);
        if (!protocol.equals(ref.getProtocol())) {
            throw new IOException("Protocol mismatch for port " + port + ": engine's protocol is " + ref.getProtocol() + ", the url protocol is " + protocol);
        }
        if (!ref.isSetThreadingParameters() && null != this.fallbackThreadingParameters) {
            if (LOG.isLoggable(Level.INFO)) {
                int min = this.fallbackThreadingParameters.getMinThreads();
                int max = this.fallbackThreadingParameters.getMaxThreads();
                LOG.log(Level.INFO, "FALLBACK_THREADING_PARAMETERS_MSG", new Object[]{port, min, max, ""});
            }
            ref.setThreadingParameters(this.fallbackThreadingParameters);
        }
        return ref;
    }

    public synchronized UndertowHTTPServerEngine createUndertowHTTPServerEngine(int port, String protocol) throws GeneralSecurityException, IOException {
        return this.createUndertowHTTPServerEngine(null, port, protocol);
    }

    public static synchronized void destroyForPort(int port) {
        UndertowHTTPServerEngine ref = portMap.remove(port);
        if (ref != null) {
            LOG.fine("Stopping Undertow HTTP Server Engine on port " + port + ".");
            try {
                ref.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MBeanServer getMBeanServer() {
        if (this.bus != null && this.bus.getExtension(InstrumentationManager.class) != null) {
            return ((InstrumentationManager)this.bus.getExtension(InstrumentationManager.class)).getMBeanServer();
        }
        return null;
    }

    public void initComplete() {
    }

    public void postShutdown() {
        UndertowHTTPServerEngine[] engines;
        for (UndertowHTTPServerEngine engine : engines = portMap.values().toArray(new UndertowHTTPServerEngine[portMap.values().size()])) {
            engine.shutdown();
        }
        this.threadingParametersMap.clear();
        this.tlsParametersMap.clear();
    }

    public void preShutdown() {
    }

    private final class UndertowBusLifeCycleListener
    implements BusLifeCycleListener {
        private UndertowBusLifeCycleListener() {
        }

        public void initComplete() {
            UndertowHTTPServerEngineFactory.this.initComplete();
        }

        public void preShutdown() {
            UndertowHTTPServerEngineFactory.this.preShutdown();
        }

        public void postShutdown() {
            UndertowHTTPServerEngineFactory.this.postShutdown();
        }
    }
}

