/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;

public class OAuthContext {
    private UserSubject resourceOwnerSubject;
    private UserSubject clientSubject;
    private List<OAuthPermission> tokenPermissions;
    private String tokenGrantType;
    private String clientId;
    private boolean isClientConfidential;
    private String tokenKey;
    private String tokenAudience;
    private String tokenIssuer;
    private String[] tokenRequestParts;
    private Map<String, String> tokenExtraProperties = new LinkedHashMap<String, String>();

    public OAuthContext(UserSubject resourceOwnerSubject, UserSubject clientSubject, List<OAuthPermission> perms, String tokenGrantType) {
        this.resourceOwnerSubject = resourceOwnerSubject;
        this.clientSubject = clientSubject;
        this.tokenPermissions = perms;
        this.tokenGrantType = tokenGrantType;
    }

    public UserSubject getSubject() {
        return this.resourceOwnerSubject;
    }

    public UserSubject getClientSubject() {
        return this.clientSubject;
    }

    public List<OAuthPermission> getPermissions() {
        return Collections.unmodifiableList(this.tokenPermissions);
    }

    public String getTokenGrantType() {
        return this.tokenGrantType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getTokenKey() {
        return this.tokenKey;
    }

    public void setTokenKey(String tokenKey) {
        this.tokenKey = tokenKey;
    }

    public String getTokenAudience() {
        return this.tokenAudience;
    }

    public void setTokenAudience(String audience) {
        this.tokenAudience = audience;
    }

    public String[] getTokenRequestParts() {
        return this.tokenRequestParts;
    }

    public void setTokenRequestParts(String[] tokenRequestParts) {
        this.tokenRequestParts = tokenRequestParts;
    }

    public boolean isClientConfidential() {
        return this.isClientConfidential;
    }

    public void setClientConfidential(boolean isConfidential) {
        this.isClientConfidential = isConfidential;
    }

    public String getTokenIssuer() {
        return this.tokenIssuer;
    }

    public void setTokenIssuer(String tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }

    public Map<String, String> getTokenExtraProperties() {
        return this.tokenExtraProperties;
    }

    public void setTokenExtraProperties(Map<String, String> tokenExtraProperties) {
        this.tokenExtraProperties = tokenExtraProperties;
    }
}

