/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.sse;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.InboundSseEvent;

class SseEventBuilder {
    static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    String theName;
    String theId;
    String theComment;
    String theData;
    Providers providers;

    SseEventBuilder(Providers providers) {
        this.providers = providers;
    }

    SseEventBuilder name(String name) {
        this.theName = name;
        return this;
    }

    SseEventBuilder id(String id) {
        this.theId = id;
        return this;
    }

    SseEventBuilder comment(String comment) {
        this.theComment = comment;
        return this;
    }

    SseEventBuilder data(String data) {
        this.theData = data;
        return this;
    }

    InboundSseEvent build() {
        return new InboundSseEventImpl(this.providers, this.theName, this.theId, this.theComment, this.theData);
    }

    static class InboundSseEventImpl
    implements InboundSseEvent {
        private final Providers providers;
        private final String name;
        private final String id;
        private final String comment;
        private final String data;

        InboundSseEventImpl(Providers providers, String name, String id, String comment, String data) {
            this.providers = providers;
            this.name = name;
            this.id = id;
            this.comment = comment;
            this.data = data;
        }

        public boolean isReconnectDelaySet() {
            return false;
        }

        public long getReconnectDelay() {
            return -1L;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public String getComment() {
            return this.comment;
        }

        public <T> T readData(GenericType<T> type, MediaType mediaType) {
            return this.readData(type.getRawType(), type.getType(), mediaType);
        }

        public <T> T readData(Class<T> messageType, MediaType mediaType) {
            return this.readData(messageType, messageType, mediaType);
        }

        public <T> T readData(GenericType<T> type) {
            return this.readData(type.getRawType(), type.getType(), this.guessMediaType(this.data));
        }

        public <T> T readData(Class<T> type) {
            return this.readData(type, type, this.guessMediaType(this.data));
        }

        private <T> T readData(Class<T> type, Type genericType, MediaType mediaType) {
            if (this.data == null) {
                return null;
            }
            try {
                MessageBodyReader mbr = this.providers.getMessageBodyReader(type, genericType, EMPTY_ANNOTATIONS, mediaType);
                if (mbr == null) {
                    throw new ProcessingException("No MessageBodyReader found to handle class type, " + String.valueOf(type) + " using MediaType, " + String.valueOf(mediaType));
                }
                return (T)mbr.readFrom(type, genericType, EMPTY_ANNOTATIONS, mediaType, (MultivaluedMap)new MultivaluedHashMap(), (InputStream)new ByteArrayInputStream(this.data.getBytes()));
            }
            catch (Exception ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }

        private MediaType guessMediaType(String dataString) {
            if (dataString != null) {
                if (dataString.startsWith("<")) {
                    return MediaType.APPLICATION_XML_TYPE;
                }
                if (dataString.startsWith("{")) {
                    return MediaType.APPLICATION_JSON_TYPE;
                }
            }
            return MediaType.WILDCARD_TYPE;
        }

        public String readData() {
            return this.data;
        }

        public boolean isEmpty() {
            return this.data == null || this.data.isEmpty();
        }
    }
}

