/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.math.BigInteger;
import java.security.AccessController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JaxbParsers {
    private static final Pattern SYSPROP = Pattern.compile("\\$\\{(?<property>[^{}]+)}");
    private static final Pattern PADDED_SYSPROP = Pattern.compile("\\s*" + SYSPROP.pattern() + "\\s*");

    public static String parsePropertyOrString(String s) {
        Matcher matcher = PADDED_SYSPROP.matcher(s);
        if (matcher.matches()) {
            String property = matcher.group("property");
            String value = AccessController.doPrivileged(() -> System.getProperty(property));
            if (value == null) {
                throw new IllegalStateException(String.format("Replacement for ${%s} not found!", property));
            }
            return value;
        }
        return s;
    }

    public static BigInteger parsePropertyOrInteger(String s) {
        return new BigInteger(JaxbParsers.parsePropertyOrString(s));
    }

    public static BigInteger parsePropertyOrPositiveInteger(String s) {
        BigInteger value = JaxbParsers.parsePropertyOrInteger(s);
        if (value.compareTo(BigInteger.ZERO) > 0) {
            return value;
        }
        throw new IllegalArgumentException("Value " + value + " is not a positive integer");
    }

    public static BigInteger parsePropertyOrNonNegativeInteger(String s) {
        BigInteger value = JaxbParsers.parsePropertyOrInteger(s);
        if (value.compareTo(BigInteger.ZERO) >= 0) {
            return value;
        }
        throw new IllegalArgumentException("Value " + value + " is not a non-negative integer");
    }

    public static String parseStringWithProperties(String s) {
        Matcher matcher = SYSPROP.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String property = matcher.group("property");
            String value = AccessController.doPrivileged(() -> System.getProperty(property));
            if (value == null) {
                throw new IllegalStateException(String.format("Replacement for ${%s} not found!", property));
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

