/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.Resources;

public class FieldChecks
implements Serializable {
    private static final Log log = LogFactory.getLog(FieldChecks.class);
    private static MessageResources sysmsgs = MessageResources.getMessageResources("org.apache.struts.validator.LocalStrings");
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateRequiredIf(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean required = false;
        value = FieldChecks.evaluateBean(bean, field);
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull(field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull(field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean thisRequired = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtils.getValueAsString(form, dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                thisRequired = dependVal == null || dependVal.length() <= 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                thisRequired = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                thisRequired = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && thisRequired : required || thisRequired;
            ++i;
        }
        if (required) {
            if (GenericValidator.isBlankOrNull(value)) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        try {
            String mask = Resources.getVarValue("mask", field, validator, request, true);
            if (value != null && value.length() > 0 && !GenericValidator.matchRegexp(value, mask)) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, "mask", e);
            return false;
        }
    }

    public static Object validateByte(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Byte result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatByte(value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateByteLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Byte result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatByte(value, locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    private static String evaluateBean(Object bean, Field field) {
        String value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString(bean, field.getProperty());
        return value;
    }

    public static Object validateShort(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Short result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatShort(value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateShortLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Short result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatShort(value, locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateInteger(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Integer result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatInt(value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateIntegerLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Integer result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatInt(value, locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateLong(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatLong(value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateLongLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatLong(value, locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateFloat(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Float result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatFloat(value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateFloatLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Float result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatFloat(value, locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDouble(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Double result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatDouble(value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDoubleLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Double result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatDouble(value, locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDate(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Date result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        boolean isStrict = false;
        String datePattern = Resources.getVarValue("datePattern", field, validator, request, false);
        if (GenericValidator.isBlankOrNull(datePattern) && !GenericValidator.isBlankOrNull(datePattern = Resources.getVarValue("datePatternStrict", field, validator, request, false))) {
            isStrict = true;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        try {
            result = GenericValidator.isBlankOrNull(datePattern) ? GenericTypeValidator.formatDate(value, locale) : GenericTypeValidator.formatDate(value, datePattern, isStrict);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? Boolean.FALSE : result;
    }

    public static boolean validateLongRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (!GenericValidator.isBlankOrNull(value)) {
            try {
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                long longValue = Long.parseLong(value);
                long min = Long.parseLong(minVar);
                long max = Long.parseLong(maxVar);
                if (min > max) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange(longValue, min, max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.processFailure(errors, field, "longRange", e);
                return false;
            }
        }
        return true;
    }

    public static boolean validateIntRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (!GenericValidator.isBlankOrNull(value)) {
            try {
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                int min = Integer.parseInt(minVar);
                int max = Integer.parseInt(maxVar);
                int intValue = Integer.parseInt(value);
                if (min > max) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange(intValue, min, max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.processFailure(errors, field, "intRange", e);
                return false;
            }
        }
        return true;
    }

    public static boolean validateDoubleRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (!GenericValidator.isBlankOrNull(value)) {
            try {
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                double doubleValue = Double.parseDouble(value);
                double min = Double.parseDouble(minVar);
                double max = Double.parseDouble(maxVar);
                if (min > max) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange(doubleValue, min, max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.processFailure(errors, field, "doubleRange", e);
                return false;
            }
        }
        return true;
    }

    public static boolean validateFloatRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (!GenericValidator.isBlankOrNull(value)) {
            try {
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                float floatValue = Float.parseFloat(value);
                float min = Float.parseFloat(minVar);
                float max = Float.parseFloat(maxVar);
                if (min > max) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange(floatValue, min, max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.processFailure(errors, field, "floatRange", e);
                return false;
            }
        }
        return true;
    }

    public static Object validateCreditCard(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatCreditCard(value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (!GenericValidator.isBlankOrNull(value) && !GenericValidator.isEmail(value)) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (value != null) {
            try {
                String maxVar = Resources.getVarValue("maxlength", field, validator, request, true);
                int max = Integer.parseInt(maxVar);
                boolean isValid = false;
                String endLth = Resources.getVarValue("lineEndLength", field, validator, request, false);
                isValid = GenericValidator.isBlankOrNull(endLth) ? GenericValidator.maxLength(value, max) : GenericValidator.maxLength(value, max, Integer.parseInt(endLth));
                if (!isValid) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.processFailure(errors, field, "maxlength", e);
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (!GenericValidator.isBlankOrNull(value)) {
            try {
                String minVar = Resources.getVarValue("minlength", field, validator, request, true);
                int min = Integer.parseInt(minVar);
                boolean isValid = false;
                String endLth = Resources.getVarValue("lineEndLength", field, validator, request, false);
                isValid = GenericValidator.isBlankOrNull(endLth) ? GenericValidator.minLength(value, min) : GenericValidator.minLength(value, min, Integer.parseInt(endLth));
                if (!isValid) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                FieldChecks.processFailure(errors, field, "minlength", e);
                return false;
            }
        }
        return true;
    }

    public static boolean validateUrl(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        UrlValidator urlValidator;
        String schemesVar;
        String nofragmentsVar;
        String value = null;
        value = FieldChecks.evaluateBean(bean, field);
        if (GenericValidator.isBlankOrNull(value)) {
            return true;
        }
        String allowallschemesVar = Resources.getVarValue("allowallschemes", field, validator, request, false);
        boolean allowallschemes = "true".equalsIgnoreCase(allowallschemesVar);
        int options = allowallschemes ? 1 : 0;
        String allow2slashesVar = Resources.getVarValue("allow2slashes", field, validator, request, false);
        if ("true".equalsIgnoreCase(allow2slashesVar)) {
            options += 2;
        }
        if ("true".equalsIgnoreCase(nofragmentsVar = Resources.getVarValue("nofragments", field, validator, request, false))) {
            options += 4;
        }
        String string = schemesVar = allowallschemes ? null : Resources.getVarValue("schemes", field, validator, request, false);
        if (options == 0 && schemesVar == null) {
            if (GenericValidator.isUrl(value)) {
                return true;
            }
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        String[] schemes = null;
        if (schemesVar != null) {
            StringTokenizer st = new StringTokenizer(schemesVar, ",");
            schemes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                schemes[i++] = st.nextToken().trim();
            }
        }
        if ((urlValidator = new UrlValidator(schemes, options)).isValid(value)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        return false;
    }

    private static void processFailure(ActionMessages errors, Field field, String validator, Throwable t) {
        String logErrorMsg = sysmsgs.getMessage("validation.failed", (Object)validator, (Object)field.getProperty(), (Object)t.toString());
        log.error(logErrorMsg);
        String userErrorMsg = sysmsgs.getMessage("system.error");
        errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
    }

    protected static boolean isString(Object o) {
        return o == null ? true : String.class.isInstance(o);
    }
}

