/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.text.lookup.InetAddressStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class InetAddressStringLookupLocalHostTest {
    InetAddressStringLookupLocalHostTest() {
    }

    @Test
    void testAddress() throws UnknownHostException {
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostAddress(), (Object)InetAddressStringLookup.LOCAL_HOST.apply("address"));
    }

    @Test
    void testBadKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> InetAddressStringLookup.LOCAL_HOST.apply("FOO"));
    }

    @Test
    void testCanonicalName() throws UnknownHostException {
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getCanonicalHostName(), (Object)InetAddressStringLookup.LOCAL_HOST.apply("canonical-name"));
    }

    @Test
    void testName() throws UnknownHostException {
        Assertions.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)InetAddressStringLookup.LOCAL_HOST.apply("name"));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)InetAddressStringLookup.LOCAL_HOST.apply(null));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)InetAddressStringLookup.LOCAL_HOST.toString().isEmpty());
    }
}

