/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.util;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.util.ClassLoaderUtils;

public class CommandLineParser {
    protected static CommandLineParser _instance = new CommandLineParser();
    private Options cmdLineOptions = null;

    public static CommandLineParser getInstance() {
        return _instance;
    }

    public void invokeCommandLineJelly(String[] args) throws JellyException {
        CommandLine cmdLine = null;
        try {
            cmdLine = this.parseCommandLineOptions(args);
        }
        catch (ParseException e) {
            throw new JellyException(e);
        }
        if (cmdLine.hasOption("h")) {
            new HelpFormatter().printHelp("jelly [scriptFile] [-script scriptFile] [-o outputFile] [-Dsysprop=syspropval] [-awt]", this.cmdLineOptions);
            System.exit(1);
        }
        if (cmdLine.hasOption("v")) {
            System.err.println("Jelly " + Jelly.getJellyVersion());
            System.err.println(" compiled: " + Jelly.getJellyBuildDate());
            System.err.println("");
            System.exit(1);
        }
        String scriptFile = null;
        scriptFile = cmdLine.hasOption("script") ? cmdLine.getOptionValue("script") : args[0];
        boolean runInSwingThread = cmdLine.hasOption("awt") || cmdLine.hasOption("swing");
        URL url = ClassLoaderUtils.getClassLoader(this.getClass()).getResource(scriptFile);
        if (url == null && !new File(scriptFile).exists()) {
            throw new JellyException("Script file " + scriptFile + " not found");
        }
        try {
            final XMLOutput output = cmdLine.hasOption("o") ? XMLOutput.createXMLOutput(new FileWriter(cmdLine.getOptionValue("o"))) : XMLOutput.createXMLOutput(System.out);
            Jelly jelly = new Jelly();
            jelly.setScript(scriptFile);
            final Script script = jelly.compileScript();
            final JellyContext context = jelly.getJellyContext();
            context.setVariable("args", args);
            context.setVariable("commandLine", cmdLine);
            if (runInSwingThread) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            script.run(context, output);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            } else {
                script.run(context, output);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            throw new JellyException(e);
        }
    }

    public CommandLine parseCommandLineOptions(String[] args) throws ParseException {
        this.cmdLineOptions = new Options();
        this.cmdLineOptions.addOption("o", true, "Output file");
        this.cmdLineOptions.addOption("script", true, "Jelly script to run");
        this.cmdLineOptions.addOption("h", "help", false, "Give this help message");
        this.cmdLineOptions.addOption("v", "version", false, "prints Jelly's version and exits");
        this.cmdLineOptions.addOption("script", true, "Jelly script to run");
        this.cmdLineOptions.addOption("awt", false, "Wether to run in the AWT thread.");
        this.cmdLineOptions.addOption("swing", false, "Synonym of \"-awt\".");
        List<String> builtinOptionNames = Arrays.asList("-o", "-script", "-h", "--help", "-v", "--version", "-awt", "-swing");
        Properties sysProps = System.getProperties();
        ArrayList<String> filteredArgList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-D") && arg.length() > 2) {
                int ePos = (arg = arg.substring(2)).indexOf("=");
                if (ePos == -1 || ePos == 0 || ePos == arg.length() - 1) {
                    System.err.println("Invalid system property: \"" + arg + "\".");
                }
                sysProps.setProperty(arg.substring(0, ePos), arg.substring(ePos + 1));
                continue;
            }
            filteredArgList.add(arg);
            if (!arg.startsWith("-") || arg.length() <= 1 || builtinOptionNames.contains(arg)) continue;
            this.cmdLineOptions.addOption(arg.substring(1, arg.length()), true, "dynamic option");
        }
        String[] filterArgs = new String[filteredArgList.size()];
        filteredArgList.toArray(filterArgs);
        GnuParser parser = new GnuParser();
        return parser.parse(this.cmdLineOptions, filterArgs);
    }
}

