/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public final class ModuleExports
implements Cloneable,
Node {
    private final int exportsIndex;
    private final int exportsFlags;
    private final int exportsToCount;
    private final int[] exportsToIndex;

    private static String getToModuleNameAtIndex(ConstantPool constantPool, int index) {
        return constantPool.getConstantString(index, (byte)19);
    }

    ModuleExports(DataInput dataInput) throws IOException {
        this.exportsIndex = dataInput.readUnsignedShort();
        this.exportsFlags = dataInput.readUnsignedShort();
        this.exportsToIndex = ClassParser.readU2U2Table(dataInput);
        this.exportsToCount = this.exportsToIndex.length;
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleExports(this);
    }

    public ModuleExports copy() {
        try {
            return (ModuleExports)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.exportsIndex);
        file.writeShort(this.exportsFlags);
        file.writeShort(this.exportsToCount);
        for (int entry : this.exportsToIndex) {
            file.writeShort(entry);
        }
    }

    public int getExportsFlags() {
        return this.exportsFlags;
    }

    public String getPackageName(ConstantPool constantPool) {
        return constantPool.constantToString(this.exportsIndex, (byte)20);
    }

    public String[] getToModuleNames(ConstantPool constantPool) {
        String[] toModuleNames = new String[this.exportsToCount];
        for (int i = 0; i < this.exportsToCount; ++i) {
            toModuleNames[i] = ModuleExports.getToModuleNameAtIndex(constantPool, this.exportsToIndex[i]);
        }
        return toModuleNames;
    }

    public String toString() {
        return "exports(" + this.exportsIndex + ", " + this.exportsFlags + ", " + this.exportsToCount + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder buf = new StringBuilder();
        String packageName = this.getPackageName(constantPool);
        buf.append(packageName);
        buf.append(", ").append(String.format("%04x", this.exportsFlags));
        buf.append(", to(").append(this.exportsToCount).append("):\n");
        for (int index : this.exportsToIndex) {
            String moduleName = ModuleExports.getToModuleNameAtIndex(constantPool, index);
            buf.append("      ").append(moduleName).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }
}

